package com.epfl.esl.sportstracker

import androidx.annotation.DrawableRes
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel

class NewRecordingViewModel: ViewModel() {
    private var _selectedSport = MutableLiveData<SPORT>(SPORT.NO_SPORT)
    val selectedSport: LiveData<SPORT>
        get() = _selectedSport

    fun updateSelectedSport(sport: SPORT) {
        _selectedSport.postValue(sport)
    }
}

enum class SPORT(val activity: String, @DrawableRes val imageResource: Int) {
    RUNNING("Running",  R.drawable.running),
    CYCLING("Cycling", R.drawable.cycling),
    SKIING("Skiing", R.drawable.skiing),
    CLIMBING("Climbing", R.drawable.climbing),
    NO_SPORT("Select activity", R.drawable.no_activity)
}