package com.epfl.esl.sportstracker

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.epfl.esl.sportstracker.ui.theme.SportsTrackerTheme

@Composable
fun AboutScreen(modifier: Modifier = Modifier) {
    Column(modifier = modifier
        .fillMaxSize()
        .padding(16.dp)) {
        Image(
            painter = painterResource(id = R.drawable.esl_logo),
            contentDescription = stringResource(
                R.string.esl_logo_content_description
            ),
            modifier = modifier.padding(bottom = 32.dp)
        )
        Text(
            text = stringResource(R.string.about_text),
            style = TextStyle(fontSize = 36.sp)
        )
    }
}

@Preview
@Composable
fun AboutScreenPreview() {
    SportsTrackerTheme {
        AboutScreen()
    }
}