package com.epfl.esl.sportstracker

import androidx.annotation.DrawableRes
import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Button
import androidx.compose.material3.Divider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.epfl.esl.sportstracker.ui.theme.SportsTrackerTheme

enum class SPORT(val activity: String, @DrawableRes val imageResource: Int) {
    RUNNING("Running", R.drawable.running),
    CYCLING("Cycling", R.drawable.cycling),
    SKIING("Skiing", R.drawable.skiing),
    CLIMBING("Climbing", R.drawable.climbing),
    NO_SPORT("Select activity", R.drawable.no_activity)
}

@Composable
fun NewRecordingScreen(onLogoutClicked: () -> Unit, modifier: Modifier = Modifier) {
    var selectedSport by remember { mutableStateOf(SPORT.NO_SPORT) }

    Surface(
        modifier = modifier.fillMaxSize(),
        color = MaterialTheme.colorScheme.background
    ) {
        Column(
            horizontalAlignment = Alignment.CenterHorizontally,
            modifier = modifier.padding(16.dp)
        ) {
            Row(
                verticalAlignment = Alignment.CenterVertically,
            ) {
                Image(
                    painter = painterResource(id = R.drawable.user_image),
                    contentDescription = stringResource(
                        R.string.user_image_content_description
                    ),
                    modifier = modifier
                        .weight(1f)
                        .padding(end = 8.dp)
                )

                Text(text = "Welcome User", modifier = modifier
                    .weight(2f)
                    .padding(end = 8.dp))

                Button(onClick = onLogoutClicked) {
                    Text(text = stringResource(id = R.string.log_out_button_text))
                }
            }

            Divider(
                color = Color.Black,
                thickness = 2.dp,
                modifier = modifier.padding(top = 16.dp, bottom = 64.dp)
            )

            Image(
                painter = painterResource(id = selectedSport.imageResource),
                contentDescription = stringResource(
                    R.string.selected_activity_content_description
                ),
                modifier.size(128.dp)
            )
            Text(text = selectedSport.activity)

            Row(
                horizontalArrangement = Arrangement.spacedBy(8.dp),
                modifier = modifier.padding(start = 16.dp, top = 32.dp, end = 16.dp)
            ) {
                Image(
                    painter = painterResource(id = R.drawable.running),
                    contentDescription = stringResource(R.string.running_activity_content_description),
                    modifier = modifier
                        .weight(1f)
                        .clickable {
                            selectedSport = SPORT.RUNNING
                        }
                )
                Image(
                    painter = painterResource(id = R.drawable.cycling),
                    contentDescription = stringResource(R.string.cycling_activity_content_description),
                    modifier = modifier
                        .weight(1f)
                        .clickable {
                            selectedSport = SPORT.CYCLING
                        }
                )
                Image(
                    painter = painterResource(id = R.drawable.skiing),
                    contentDescription = stringResource(R.string.skiing_activity_content_description),
                    modifier = modifier
                        .weight(1f)
                        .clickable {
                            selectedSport = SPORT.SKIING
                        }
                )
                Image(
                    painter = painterResource(id = R.drawable.climbing),
                    contentDescription = stringResource(R.string.climbing_activity_content_description),
                    modifier = modifier
                        .weight(1f)
                        .clickable {
                            selectedSport = SPORT.CLIMBING
                        }
                )
            }
        }
    }
}

@Preview
@Composable
fun NewRecordingScreenPreview() {
    SportsTrackerTheme {
        NewRecordingScreen(onLogoutClicked = {})
    }
}