function BER = Simulator_P1T2_template(SNR, mapping_type)
%default values
if nargin < 1
    SNR=100;
    mapping_type ="QAM16";
end

% Initialization
BER = zeros(size(SNR));

% number of bits
numbits = 10^4;
 
switch mapping_type
       case 'QAM16'
            Map_nonorm = [(-3 + 3j) (-3 + 1j) (-3 - 3j) (-3 -1j) ...   % not normalized symbols
             (-1 + 3j) (-1 + 1j) (-1 - 3j) (-1 - 1j) ...
             (3 + 3j) (3 + 1j) (3 - 3j) (3 -1j) ...
             (1 + 3j) (1 + 1j) (1 - 3j) (1 - 1j)];

       case 'PSK16'
            Map_nonorm = exp([0,1,3,2,7,6,4,5,15,14,12,13,8,9,11,10].*j*2*pi/16)  ;          

    otherwise
        error("Mapping type not supported")
end 

% normalized mapping

for ii = 1: length(SNR)
    % Convert SNR from dB to linear

    % Generate source bitstream

    % Map input bitstream into Symbols
   
    % Add AWGN
   
    % Demapping

    % calculate BER
    BER(ii) = 0;

end
