* Simulation of the CS amplifier
.LIB ekv018.mdl
.INCLUDE size_bias.par
.PARAM q=1.60217662E-19 kb=1.38064852E-23 kT=kb*T T=300 UT=kb*T/q
.OPTION DAT
.OP OPINFO=ALL
.AC dec {fdec} {fmin} {fmax}
.TRACE AC dB(V(out))
.TRACE AC P(V(out)) 
.MEASURE NAME=Adc WAVEFORM=VDB(out) ANALYSIS=AC EXTRACT=MAX
.MEASURE NAME=GBW WAVEFORM=VDB(out) ANALYSIS=AC EXTRACT=X ATY=0 CROSS=DOWN OCCUR=1
.MEASURE NAME=fp1 WAVEFORM=P(V(out)) ANALYSIS=AC EXTRACT=X ATY=135 CROSS=DOWN OCCUR=1
.MEASURE NAME=fp2 WAVEFORM=P(V(out)) ANALYSIS=AC EXTRACT=X ATY=45 CROSS=DOWN OCCUR=1

.NOISE V(out) Vin {fdec} {fmin} {fmax} op=no compress=no compressCoeff=1 compressTolX=0 compressTolY=1u
.TRACE Noise INOISE ITHN IFLN
*.TRACE Noise {SnindBv = 20 * log10(INOISE)} {SninthdBv = 20 * log10(ITHN)} {SninfldBv = 20 * log10(IFLN)}
.MEASURE NAME=Vnth WAVEFORM=ITHN ANALYSIS=NOISE EXTRACT=MAX
.MEASURE NAME=fk WAVEFORM=IFLN ANALYSIS=NOISE EXTRACT=X ATY=Vnth CROSS=DOWN OCCUR=1
