%% Generate Measurements
% Call to your script generating the constants.

disp('Constants generated')

% Defining your custom variables

% Running simulation
disp('Starting simulation ...');

disp('Simulation -> ok');

%% Doing the export
% Getting the data from the SimOut File
disp('Getting data');
nbRows = length(Text);
nbCols = size(SimOut.Data,2)/length(Text);
for j=nbCols:-1:1
    Data2Export(:,j) = SimOut.Data(end,1+(j-1)*nbRows:nbRows+(j-1)*nbRows)';
end

% Exporting to a Table compatible with the MatlabApp
disp('Exporting Table');
Table2Export = cell(nbRows,nbCols);
for i=1:nbRows
    for j=1:nbCols
        singleData = Data2Export(i,j);
        if singleData > 500
            Table2Export(i,j)= cellstr(sprintf('%.0f', singleData));
        elseif singleData > 15    
            Table2Export(i,j)= cellstr(sprintf('%.1f', singleData));
        elseif singleData > 5                    
            Table2Export(i,j)= cellstr(sprintf('%.2f', singleData));
        else 
            Table2Export(i,j)= cellstr(sprintf('%.3f', singleData));
        end
    end
end
disp('Finished -> OK');