---=============================================================================
-- @file task2_2.vhdl
--=============================================================================
-- Standard library
library ieee;
-- Standard packages
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity task2_2 is
  port (
    CLKxCI  : in std_logic;
    RSTxRI  : in std_logic;
    SelxSI  : in std_logic_vector(2-1 downto 0);
    AxDI    : in unsigned(8-1 downto 0);
    ResxDO  : out unsigned(8-1 downto 0)
  );
end task2_2;

architecture rtl of task2_2 is
  signal ResxDN, ResxDP : unsigned(8-1 downto 0);
begin

process (CLKxCI, RSTxRI)
begin
  if (RSTxRI ='1') then
    ResxDP <= (others => '0');
  elsif (CLKxCI'event and CLKxCI = '1') then
    ResxDP <= ResxDN;
  end if;
end process;

process(all)
begin
  if (SelxSI = "00") then
    if (AxDI >= 127) then
      ResxDN <= to_unsigned(1, ResxDN'length);
    else
      ResxDN <= (others => '0');
    end if;
  elsif (SelxSI = "01") then
    if (AxDI >= 127) then
      ResxDN <= AxDI;
    else
      ResxDN <= (others => '0');
    end if;
  elsif (SelxSI = "10") then
    ResxDN <= '0' & AxDI(8-1 downto 1);
  else
    ResxDN <= AxDI(8-2 downto 0) & '0';
  end if;
end process;

ResxDO <= ResxDP;
end rtl;
