--=============================================================================
-- @file task2_1.vhdl
--=============================================================================
-- Standard library
library ieee;
-- Standard packages
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity task2_1 is
  port ( 
  CLKxCI   : in std_logic;
  RSTxRI   : in std_logic;
  ENxSI    : in std_logic;
  ClearxSI : in std_logic;
  AxDI     : in unsigned(16-1 downto 0);
  BxDI     : in unsigned(16-1 downto 0);
  MacxDO   : out unsigned(16-1 downto 0)
  );
end task2_1;

architecture rtl of task2_1 is
  signal ProdxS                : unsigned(32-1 downto 0);
  signal SumxS, MacxDN, MacxDP : unsigned(16-1 downto 0);
begin

process (CLKxCI, RSTxRI)
  begin
    if (RSTxRI ='1') then
      MacxDP <= (others => '0');
    elsif (CLKxCI'event and CLKxCI = '1') then
      MacxDP <= MacxDN;
    end if;
  end process;

  ProdxS <= AxDI * BxDI;
  SumxS  <= ProdxS(16-1 downto 0) + MACxDP;
  MacxDN <= ProdxS(16-1 downto 0) when ClearxSI = '1' and ENxSI = '1' else
            SumxS                 when ENxSI    = '1' else 
            MACxDP;

  MacxDO <= MACxDP;
end rtl;