--=============================================================================
-- @file task1_1.vhdl
--=============================================================================
-- Standard library
library ieee;
-- Standard packages
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity task1_1 is
  port (
    CLKxCI, RSTxRI : in std_logic;
    ONxSI, OFFxSI  : in std_logic;
    OutxDO : out unsigned(24-1 downto 0)
  );
end task1_1;

architecture rtl of task1_1 is
  signal AxD, BxD, CxD : unsigned(8-1 downto 0);
begin

  process(CLKxCI, RSTxRI)
  begin
    if (RSTxRI = '1') then
      AxD <= (others => '0');    
      BxD <= (others => '0');
      CxD <= (others => '0');
    elsif (CLKxCI'event and CLKxCI = '1') then
      if (OFFxSI = '1') then
        AxD <= (others => '0');    
        BxD <= (others => '0');
        CxD <= (others => '0');
      end if;
      if (ONxSI = '1') then
        AxD <= AxD + 1;
        BxD <= AxD xor "10101010";
        CxD <= BxD - 1;
      end if;
    end if;
  end process;
  OutxDO <= AxD * BxD * CxD;
end rtl;