#include <nds.h>

#include "game.h"
#include "graphics.h"
#include "colors.h"


int playerLost = 0;

// Tiles for losing
u8 red_Tile[64] = {
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
};

// Tiles for successfully starting the game
// CYAN TILE - Shape: complementary to diamond tile
u8 empty_newTile[64] = {
    2,2,2,0,0,2,2,2,
    2,2,0,0,0,0,2,2,
    2,0,0,0,0,0,0,2,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    2,0,0,0,0,0,0,2,
    2,2,0,0,0,0,2,2,
    2,2,2,0,0,2,2,2,
};

// New tiles for player after starting the game
u8 player_newTile[64] = {
    2,2,2,1,1,2,2,2,
    2,2,1,1,1,1,2,2,
    2,1,1,1,1,1,1,2,
    1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,
    2,1,1,1,1,1,1,2,
    2,2,1,1,1,1,2,2,
    2,2,2,1,1,2,2,2,
};



int playerX1, playerX2, playerY1, playerY2;

// Initialize player position in the central tiles
void initPlayerCenter() {
    playerX1 = 15;
    playerX2 = 16;
    playerY1 = 11;
    playerY2 = 12;
}

void movePlayerRight() {
    #ifndef PORTAL_ACTIVE
    // Check if player is at the right edge -> No movement
    // ... TO COMPLETE EXERCISE 4
    #else
    // Check if player is at the right edge before the portal -> Teleport to the left edge
    // ... TO COMPLETE EXERCISE 5
    #endif

    // Clear the previous position using tile 0
    // ... TO COMPLETE EXERCISE 4

    // Move player right and update the tile map
    // ... TO COMPLETE EXERCISE 4
    

}

void movePlayerLeft() {
    // Check if player is at the left edge -> No movement
    // ... TO COMPLETE EXERCISE 4

    // Clear the previous position using tile 0
    // ... TO COMPLETE EXERCISE 4

    // Move player left and update the tile map
    // ... TO COMPLETE EXERCISE 4

}

void movePlayerUp() {
    // Check if player is at the top edge -> No movement
    // ... TO COMPLETE EXERCISE 4

    // Clear the previous position using tile 0
    // ... TO COMPLETE EXERCISE 4

    // Move player up and update the tile map
    // ... TO COMPLETE EXERCISE 4

}

void movePlayerDown() {
    // Check if player is at the bottom edge -> No movement
    // ... TO COMPLETE EXERCISE 4

    // Clear the previous position using tile 0
    // ... TO COMPLETE EXERCISE 4

    // Move player down and update the tile map
    // ... TO COMPLETE EXERCISE 4

}



void initGame() {
    // Disable the timer that causes defeat
    irqDisable(IRQ_TIMER0);

    // Add CYAN to the palette
    BG_PALETTE[2] = CYAN;

    // Copy the tile(s) to the VRAM
    dmaCopy(empty_newTile, (u8*)BG_TILE_RAM(0), 64);           // Replace empty_Tile with empty_newTile in Tile 0
    dmaCopy(player_newTile, (u8*) BG_TILE_RAM(0) + 64, 64);   // Replace player_Tile with player_newTile in Tile 1
    

    // Fill the screen with CYAN tiles apart from the player
    for(int i=0;i<24;i++) {
        for(int j=0;j<32;j++) {
            BG_MAP_RAM(1)[i*32+j] = 0;
        }
    }

    // Set the updated player tiles in the center of the screen
    BG_MAP_RAM(1)[11*32+15] = 1;
    BG_MAP_RAM(1)[11*32+16] = 1;
    BG_MAP_RAM(1)[12*32+15] = 1;
    BG_MAP_RAM(1)[12*32+16] = 1;


    // Part of Exercise 5
	// Configure background 2 in main screen to draw the portal
	#ifdef PORTAL_ACTIVE
	configBG2_Main();
	#endif

}


void playerLoses() {
    playerLost = 1;

    // Copy the red tile to the VRAM
    dmaCopy(red_Tile, (u8*) BG_TILE_RAM(0) + 128, 64);

    // Fill the screen with red tiles
    for(int i=0;i<24;i++) {
        for(int j=0;j<32;j++) {
            BG_MAP_RAM(1)[i*32+j] = 2;
        }
    }

}

