/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import uchicago.src.sim.parameter.rpl.BooleanRPLConstant;
import uchicago.src.sim.parameter.rpl.ListRPLParameter;
import uchicago.src.sim.parameter.rpl.NumericRPLConstant;
import uchicago.src.sim.parameter.rpl.NumericRPLParameter;
import uchicago.src.sim.parameter.rpl.RPLList;
import uchicago.src.sim.parameter.rpl.RPLObject;
import uchicago.src.sim.parameter.rpl.RPLParameter;
import uchicago.src.sim.parameter.rpl.StringRPLConstant;

public class RPLFactory {
    private static Map typeMap = new HashMap();
    private static Map convertorMap = new HashMap();
    private static Set numberClassSet = new HashSet();

    public static RPLList createRPLList(List list) {
        Object object;
        if (list.size() == 0) {
            throw new NoSuchElementException("list cannot be empty");
        }
        Class clazz = ((RPLObject)list.get(0)).getType();
        boolean bl = false;
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            RPLObject rPLObject = (RPLObject)list.get(i);
            object = rPLObject.getType();
            if (clazz.equals(object)) continue;
            if (RPLFactory.isConvertable(clazz, (Class)object)) {
                clazz = object;
                bl = true;
                continue;
            }
            if (RPLFactory.isConvertable((Class)object, clazz)) continue;
            throw new ClassCastException("elements of the list must be all of the same type");
        }
        RPLList rPLList = new RPLList(clazz);
        if (bl) {
            Convertor convertor = (Convertor)convertorMap.get(clazz);
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                RPLObject rPLObject = (RPLObject)list.get(i);
                rPLList.add(convertor.convert(rPLObject.getValue()));
            }
        } else {
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                object = (RPLObject)list.get(n);
                rPLList.add(object.getValue());
            }
        }
        return rPLList;
    }

    private static boolean isConvertable(Class clazz, Class clazz2) {
        HashSet hashSet = (HashSet)typeMap.get(clazz);
        if (hashSet == null) {
            return false;
        }
        return hashSet.contains(clazz2);
    }

    public static RPLParameter createConstant(String string, RPLObject rPLObject) {
        if (rPLObject.getType().equals(String.class)) {
            return new StringRPLConstant(string, (String)rPLObject.getValue());
        }
        if (rPLObject.getType().equals(Boolean.TYPE)) {
            Boolean bl = (Boolean)rPLObject.getValue();
            return new BooleanRPLConstant(string, bl);
        }
        double d = new Double(rPLObject.getValue().toString());
        return new NumericRPLConstant(string, d);
    }

    public static RPLParameter createParameter(String string, RPLList rPLList) {
        return new ListRPLParameter(string, rPLList);
    }

    public static RPLParameter createParameter(String string, RPLObject rPLObject, RPLObject rPLObject2) {
        if (numberClassSet.contains(rPLObject.getType()) && numberClassSet.contains(rPLObject2.getType())) {
            double d;
            double d2 = new Double(rPLObject.getValue().toString());
            if (d2 <= (d = new Double(rPLObject2.getValue().toString()).doubleValue())) {
                throw new IllegalArgumentException("ending parameter value must be greater than starting value");
            }
            return new NumericRPLParameter(string, d2, d);
        }
        throw new ClassCastException("parameter start and end values must be numeric");
    }

    public static RPLParameter createParameter(String string, RPLObject rPLObject, RPLObject rPLObject2, RPLObject rPLObject3) {
        if (numberClassSet.contains(rPLObject.getType()) && numberClassSet.contains(rPLObject2.getType()) && numberClassSet.contains(rPLObject3.getType())) {
            double d = new Double(rPLObject.getValue().toString());
            double d2 = new Double(rPLObject2.getValue().toString());
            double d3 = new Double(rPLObject3.getValue().toString());
            if (d >= d2 && d3 > 0.0) {
                throw new IllegalArgumentException("ending parameter value must be greater than starting value.");
            }
            if (d <= d2 && d3 < 0.0) {
                throw new IllegalArgumentException("ending parameter value must be less than starting value.");
            }
            return new NumericRPLParameter(string, d, d2, d3);
        }
        throw new ClassCastException("parameter star, end and increment values must be numeric.");
    }

    static {
        HashSet<Class<Number>> hashSet = new HashSet<Class<Number>>();
        hashSet.add(Double.TYPE);
        hashSet.add(Float.TYPE);
        hashSet.add(Long.TYPE);
        typeMap.put(Integer.TYPE, hashSet);
        hashSet = new HashSet();
        hashSet.add(Float.TYPE);
        hashSet.add(Double.TYPE);
        typeMap.put(Long.TYPE, hashSet);
        hashSet = new HashSet();
        hashSet.add(Double.TYPE);
        typeMap.put(Float.TYPE, hashSet);
        hashSet = new HashSet();
        typeMap.put(Double.TYPE, hashSet);
        convertorMap.put(Integer.TYPE, new IntConvertor());
        convertorMap.put(Double.TYPE, new DoubleConvertor());
        convertorMap.put(Float.TYPE, new FloatConvertor());
        convertorMap.put(Long.TYPE, new LongConvertor());
        numberClassSet.add(Integer.TYPE);
        numberClassSet.add(Double.TYPE);
        numberClassSet.add(Float.TYPE);
        numberClassSet.add(Long.TYPE);
        numberClassSet.add(Integer.class);
        numberClassSet.add(Long.class);
        numberClassSet.add(Float.class);
        numberClassSet.add(Double.class);
    }

    static class IntConvertor
    implements Convertor {
        IntConvertor() {
        }

        public Object convert(Object object) {
            return new Integer(object.toString());
        }
    }

    static class FloatConvertor
    implements Convertor {
        FloatConvertor() {
        }

        public Object convert(Object object) {
            return new Float(object.toString());
        }
    }

    static class LongConvertor
    implements Convertor {
        LongConvertor() {
        }

        public Object convert(Object object) {
            return new Long(object.toString());
        }
    }

    static class DoubleConvertor
    implements Convertor {
        DoubleConvertor() {
        }

        public Object convert(Object object) {
            return new Double(object.toString());
        }
    }

    static interface Convertor {
        public Object convert(Object var1);
    }
}

