/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import uchicago.src.sim.engine.gui.model.DataParameter;

public class XMLParameterFileWriter {
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private String indent = new String();

    public void write(String string, DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            PrintStream printStream = new PrintStream((OutputStream)fileOutputStream, false, DEFAULT_CHARACTER_ENCODING);
            printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writeXml(printStream, "<Repast:Params xmlns:Repast=\"http://www.src.uchicago.edu\">");
            this.writeTree(printStream, defaultMutableTreeNode);
            this.writeOutputParameters(arrayList, printStream);
            this.writeXml(printStream, "</Repast:Params>");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeTree(PrintStream printStream, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        Object object = defaultMutableTreeNode2.getUserObject();
        DataParameter dataParameter = null;
        dataParameter = object != null && object instanceof DataParameter ? (DataParameter)object : null;
        if (dataParameter == null) {
            while (enumeration.hasMoreElements()) {
                this.writeTree(printStream, (DefaultMutableTreeNode)enumeration.nextElement());
            }
        } else if (enumeration.hasMoreElements()) {
            this.openXmlBlock(printStream, dataParameter.toXMLOpenString());
            while (enumeration.hasMoreElements()) {
                this.writeTree(printStream, (DefaultMutableTreeNode)enumeration.nextElement());
            }
            this.closeXmlBlock(printStream, dataParameter.toXMLCloseString());
        } else {
            this.openAndCloseXmlBlock(printStream, dataParameter.toXMLOpenString());
        }
    }

    private void writeXml(PrintStream printStream, String string) {
        printStream.println(this.indent + string);
    }

    private void openXmlBlock(PrintStream printStream, String string) {
        this.writeXml(printStream, "<" + string + ">");
        this.indent = this.indent + "    ";
    }

    private void openAndCloseXmlBlock(PrintStream printStream, String string) {
        this.writeXml(printStream, "<" + string + "/>");
    }

    private void closeXmlBlock(PrintStream printStream, String string) {
        this.indent = this.indent.substring(0, this.indent.length() - 4);
        printStream.println(this.indent + "</" + string + ">");
    }

    private void writeOutputParameters(ArrayList arrayList, PrintStream printStream) {
        DataParameter dataParameter = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            dataParameter = (DataParameter)arrayList.get(i);
            this.openAndCloseXmlBlock(printStream, dataParameter.toXMLOpenString());
        }
    }
}

