/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.BinaryHeap;
import uchicago.src.sim.network.DefaultEdge;
import uchicago.src.sim.network.DefaultNode;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.NetworkPath;
import uchicago.src.sim.network.Node;

public class ShortestNetworkPath {
    private BinaryHeap V = new BinaryHeap(true, new Comparator(){

        public int compare(Object object, Object object2) {
            DefaultNode defaultNode = (DefaultNode)object;
            DefaultNode defaultNode2 = (DefaultNode)object2;
            int n = 0;
            if ((Double)ShortestNetworkPath.this.d.get(defaultNode) < (Double)ShortestNetworkPath.this.d.get(defaultNode2)) {
                return -1;
            }
            if ((Double)ShortestNetworkPath.this.d.get(defaultNode) > (Double)ShortestNetworkPath.this.d.get(defaultNode2)) {
                return 1;
            }
            return n;
        }
    });
    HashMap d;
    HashMap pi;
    DefaultNode i;
    List nodes;

    public HashMap getPi() {
        return this.pi;
    }

    public ShortestNetworkPath(List list, DefaultNode defaultNode) {
        this.nodes = list;
        this.i = defaultNode;
        this.d = new HashMap(list.size());
        this.pi = new HashMap(list.size());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Node node = (Node)listIterator.next();
            this.d.put(node, new Double(Double.MAX_VALUE));
            this.pi.put(node, null);
        }
        this.d.put(defaultNode, new Double(0.0));
        this.dijkstra();
    }

    public void relax(DefaultNode defaultNode, DefaultNode defaultNode2) {
        double d;
        Edge edge = (Edge)defaultNode.getEdgesTo(defaultNode2).iterator().next();
        double d2 = (Double)this.d.get(defaultNode2);
        if (d2 > (d = ((Double)this.d.get(defaultNode)).doubleValue()) + edge.getStrength()) {
            this.d.put(defaultNode2, new Double(d + edge.getStrength()));
            this.pi.put(defaultNode2, defaultNode);
        }
    }

    public void dijkstra() {
        this.V.addAll((Collection)this.nodes);
        while (!this.V.isEmpty()) {
            DefaultNode defaultNode = (DefaultNode)this.V.pop();
            ArrayList arrayList = defaultNode.getOutEdges();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DefaultNode defaultNode2 = (DefaultNode)((DefaultEdge)iterator.next()).getTo();
                this.relax(defaultNode, defaultNode2);
            }
        }
    }

    public NetworkPath getPath(DefaultNode defaultNode) {
        NetworkPath networkPath = new NetworkPath((Double)this.d.get(defaultNode));
        while (defaultNode != this.i) {
            if (this.pi.get(defaultNode) == null) {
                return null;
            }
            networkPath.push(defaultNode);
            defaultNode = (DefaultNode)this.pi.get(defaultNode);
        }
        networkPath.push(this.i);
        return networkPath;
    }

    public static void main(String[] stringArray) {
        DefaultNode defaultNode = new DefaultNode("node1");
        DefaultNode defaultNode2 = new DefaultNode("node2");
        DefaultNode defaultNode3 = new DefaultNode("node3");
        DefaultNode defaultNode4 = new DefaultNode("node4");
        DefaultNode defaultNode5 = new DefaultNode("node5");
        DefaultEdge defaultEdge = new DefaultEdge(defaultNode, defaultNode2);
        defaultEdge.setStrength(25.4);
        defaultNode.addOutEdge(defaultEdge);
        defaultNode2.addInEdge(defaultEdge);
        DefaultEdge defaultEdge2 = new DefaultEdge(defaultNode2, defaultNode3);
        defaultEdge2.setStrength(423.5);
        defaultNode2.addOutEdge(defaultEdge2);
        defaultNode3.addInEdge(defaultEdge2);
        DefaultEdge defaultEdge3 = new DefaultEdge(defaultNode, defaultNode4);
        defaultEdge3.setStrength(429.5);
        defaultNode.addOutEdge(defaultEdge3);
        defaultNode4.addInEdge(defaultEdge3);
        ArrayList<DefaultNode> arrayList = new ArrayList<DefaultNode>();
        arrayList.add(defaultNode);
        arrayList.add(defaultNode2);
        arrayList.add(defaultNode3);
        arrayList.add(defaultNode4);
        arrayList.add(defaultNode5);
        ShortestNetworkPath shortestNetworkPath = new ShortestNetworkPath(arrayList, defaultNode);
        shortestNetworkPath.dijkstra();
        NetworkPath networkPath = shortestNetworkPath.getPath(defaultNode3);
        if (networkPath != null) {
            for (int i = 0; i < networkPath.size(); ++i) {
                DefaultNode defaultNode6 = (DefaultNode)networkPath.get(i);
                System.out.println("node.getNodeLabel() = " + defaultNode6.getNodeLabel());
            }
            System.out.println("path.getDistance() = " + networkPath.getDistance());
            System.out.println("path.getSubpathDistance(node2, node3) = " + networkPath.getSubpathDistance(defaultNode2, defaultNode3));
        } else {
            System.out.println("no path");
        }
    }
}

