/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.DrawableNonGridNode;
import uchicago.src.sim.gui.LayoutWithDisplay;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.NetUtilities;

public class FruchGraphLayout
extends LayoutWithDisplay {
    private int pad = 20;
    private int initialIter = 30;
    private int maxPasses = 500;
    private double optDist = 10.0;
    private int updates = 0;
    private boolean rescaleLayout = true;
    private boolean animate = true;
    private boolean firstLayout = true;
    private boolean noBreak = true;
    private int seed;
    private boolean isSeedSet = false;

    public FruchGraphLayout(int n, int n2) {
        super(n, n2);
    }

    public FruchGraphLayout(List list, int n, int n2) {
        super(list, n, n2);
    }

    public FruchGraphLayout(List list, int n, int n2, DisplaySurface displaySurface, int n3) {
        super(list, n, n2, displaySurface);
        this.updates = n3;
    }

    public void setPad(int n) {
        this.pad = n;
    }

    public void setUpdateEveryN(int n) {
        this.updates = n;
    }

    public void setRescaleLayout(boolean bl) {
        this.rescaleLayout = bl;
    }

    public void setAnimateTransitions(boolean bl) {
        this.animate = bl;
    }

    private double calcAttraction(double d) {
        return d * d / this.optDist;
    }

    private double calcRepulsion(double d) {
        return this.optDist * this.optDist / d;
    }

    private double coolTemp(double d) {
        return d / 1.1;
    }

    public void setRandomSeed(int n) {
        this.seed = n;
        this.isSeedSet = true;
    }

    public void randomizeLayout() {
        MersenneTwister mersenneTwister = null;
        mersenneTwister = this.isSeedSet ? new MersenneTwister(this.seed) : new MersenneTwister(new Date());
        Uniform uniform = new Uniform((RandomEngine)mersenneTwister);
        int n = this.nodeList.size();
        int n2 = this.width - this.pad;
        int n3 = this.height - this.pad;
        for (int i = 0; i < n; ++i) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)this.nodeList.get(i);
            drawableNonGridNode.setX(uniform.nextIntFromTo(0, n2));
            drawableNonGridNode.setY(uniform.nextIntFromTo(0, n3));
        }
    }

    public void updateLayout() {
        if (this.update) {
            Object object;
            int n;
            Object object2;
            this.isEventThread = SwingUtilities.isEventDispatchThread();
            this.noBreak = true;
            this.optDist = 0.46 * Math.sqrt(this.width * this.height / (this.nodeList.size() + 1));
            double d = this.width / 10;
            int n2 = 0;
            int n3 = this.nodeList.size();
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            ArrayList arrayList = new ArrayList();
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            if (this.firstLayout) {
                this.randomizeLayout();
                this.firstLayout = false;
            }
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                object2 = (DrawableNonGridNode)this.nodeList.get(i);
                dArray[i] = object2.getX();
                dArray2[i] = object2.getY();
                arrayList.addAll(object2.getOutEdges());
                hashMap.put(object2, new Integer(i));
            }
            if (NetUtilities.hasSelfLoops(this.nodeList)) {
                arrayList = this.removeLoops(arrayList);
            }
            double[] dArray3 = new double[n3];
            object2 = new double[n3];
            while (d > 1.0 && n2 < this.maxPasses && this.noBreak) {
                int n4;
                n = n3 - 1;
                for (int i = 0; i < n; ++i) {
                    dArray3[i] = 0.0;
                    object2[i] = 0.0;
                    for (n4 = i + 1; n4 < n3; ++n4) {
                        d2 = dArray[i] - dArray[n4];
                        d3 = dArray2[i] - dArray2[n4];
                        if (d2 == 0.0 && d3 == 0.0) continue;
                        d4 = Math.sqrt(d2 * d2 + d3 * d3);
                        d5 = this.calcRepulsion(d4);
                        int n5 = i;
                        dArray3[n5] = dArray3[n5] + d2 / d4 * d5;
                        Object object3 = object2;
                        int n6 = i;
                        object3[n6] = object3[n6] + d3 / d4 * d5;
                        int n7 = n4;
                        dArray3[n7] = dArray3[n7] - d2 / d4 * d5;
                        Object object4 = object2;
                        int n8 = n4;
                        object4[n8] = object4[n8] - d3 / d4 * d5;
                    }
                }
                object = arrayList.iterator();
                while (object.hasNext() && this.noBreak) {
                    int n9;
                    Edge edge = (Edge)object.next();
                    int n10 = (Integer)hashMap.get(edge.getFrom());
                    d2 = dArray[n10] - dArray[n9 = ((Integer)hashMap.get(edge.getTo())).intValue()];
                    d4 = Math.sqrt(d2 * d2 + (d3 = dArray2[n10] - dArray2[n9]) * d3);
                    if (d4 == 0.0) {
                        d4 = 0.001;
                    }
                    d5 = this.calcAttraction(d4);
                    int n11 = n10;
                    dArray3[n11] = dArray3[n11] - d2 / d4 * d5;
                    Object object5 = object2;
                    int n12 = n10;
                    object5[n12] = object5[n12] - d3 / d4 * d5;
                    int n13 = n9;
                    dArray3[n13] = dArray3[n13] + d2 / d4 * d5;
                    Object object6 = object2;
                    int n14 = n9;
                    object6[n14] = object6[n14] + d3 / d4 * d5;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    double d6 = dArray3[n4];
                    Object object7 = object2[n4];
                    d4 = Math.sqrt(d6 * d6 + object7 * object7);
                    if (d4 > d) {
                        int n15 = n4;
                        dArray[n15] = dArray[n15] + dArray3[n4] / (d4 / d);
                        int n16 = n4;
                        dArray2[n16] = dArray2[n16] + object2[n4] / (d4 / d);
                        continue;
                    }
                    int n17 = n4;
                    dArray[n17] = dArray[n17] + dArray3[n4];
                    int n18 = n4;
                    dArray2[n18] = dArray2[n18] + object2[n4];
                }
                if (n2 > this.initialIter) {
                    d = this.coolTemp(d);
                }
                if (this.updates > 0 && n2 % this.updates == 0) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)this.nodeList.get(n4);
                        drawableNonGridNode.setX(dArray[n4]);
                        drawableNonGridNode.setY(dArray2[n4]);
                    }
                    this.updateDisplay();
                }
                ++n2;
            }
            if (this.rescaleLayout) {
                this.rescalePositions(this.nodeList, dArray, dArray2);
            } else if (this.animate) {
                this.animateTransition(10, this.nodeList, dArray, dArray2);
            } else {
                for (n = 0; n < n3; ++n) {
                    object = (DrawableNonGridNode)this.nodeList.get(n);
                    object.setX(dArray[n]);
                    object.setY(dArray2[n]);
                }
                this.updateDisplay();
            }
        }
    }

    private void rescalePositions(ArrayList arrayList, double[] dArray, double[] dArray2) {
        int n;
        int n2 = arrayList.size();
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n2; ++i) {
            d = Math.max(d, dArray[i]);
            d2 = Math.max(d2, dArray2[i]);
            d3 = Math.min(d3, dArray[i]);
            d4 = Math.min(d4, dArray2[i]);
        }
        if (d == d3) {
            d3 = 0.0;
            d *= 2.0;
        }
        if (d2 == d4) {
            d4 = 0.0;
            d2 *= 2.0;
        }
        double d5 = d - d3;
        double d6 = d2 - d4;
        int n3 = this.width - this.pad;
        int n4 = this.height - this.pad;
        for (n = 0; n < n2; ++n) {
            dArray[n] = (dArray[n] - d3) / d5 * (double)n3;
            dArray2[n] = (dArray2[n] - d4) / d6 * (double)n4;
        }
        n = 10;
        if (this.animate) {
            this.animateTransition(n, arrayList, dArray, dArray2);
        } else {
            for (int i = 0; i < n2; ++i) {
                DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
                drawableNonGridNode.setX(dArray[i]);
                drawableNonGridNode.setY(dArray2[i]);
            }
            this.updateDisplay();
        }
    }

    private void animateTransition(int n, ArrayList arrayList, double[] dArray, double[] dArray2) {
        int n2 = arrayList.size();
        for (int i = 1; i <= n; ++i) {
            this.updateDisplay();
            for (int j = 0; j < n2; ++j) {
                DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(j);
                drawableNonGridNode.setX(drawableNonGridNode.getX() + (dArray[j] - drawableNonGridNode.getX()) * (double)i / (double)n);
                drawableNonGridNode.setY(drawableNonGridNode.getY() + (dArray2[j] - drawableNonGridNode.getY()) * (double)i / (double)n);
            }
        }
    }

    private ArrayList removeLoops(ArrayList arrayList) {
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getFrom().equals(edge.getTo())) continue;
            arrayList2.add(edge);
        }
        return arrayList2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.noBreak = false;
    }
}

