/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import layout.TableLayout;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.engine.LoadModelTree;
import uchicago.src.sim.engine.ModelTreeNode;
import uchicago.src.sim.engine.ParameterFileListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.gui.ParameterWizard;
import uchicago.src.sim.engine.gui.components.ParameterData;
import uchicago.src.sim.util.Disassembler;
import uchicago.src.sim.util.SimUtilities;

public class LoadModelDialog
implements ParameterFileListener {
    private JDialog dialog = null;
    private LoadModelTree tree = new LoadModelTree();
    private JLabel lblName = new JLabel();
    private JLabel lblPath = new JLabel();
    private JTextField txtParamFile = new JTextField();
    private JLabel lblModelClass = new JLabel();
    private JButton btnParamBrowse = new JButton("...");
    private JButton btnAdd = new JButton("Add");
    private JButton load = new JButton("Load");
    private JButton cancel = new JButton("Cancel");
    private JButton parameterWizardButton = new JButton("Parameter Wizard");
    private JPanel mainPanel;
    private String modelsDir;
    private String demoDir;
    private SimModel selectedModel = null;
    private HashSet demoExclude = new HashSet();
    private Comparator modelComp = new ModelComparator();
    private CLoader loader = new CLoader(new URL[0], this.getClass().getClassLoader());

    public LoadModelDialog() {
        this.demoExclude.add("uchicago.src.repastdemos.heatBugs.HBNoGui");
        this.demoExclude.add("uchicago.src.repastdemos.enn.EnnBase");
        this.demoExclude.add("uchicago.src.repastdemos.enn.EnnBatchModel");
        this.demoExclude.add("uchicago.src.repastdemos.schellingGis.SchellingGis");
        this.guiInit();
        this.addListeners();
        this.findPaths();
        try {
            this.getSimModels(new File("."));
            if (this.demoDir != null) {
                this.loadDemos();
            }
            if (this.modelsDir != null) {
                this.loadModels();
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error creating LoadModelDialog", iOException);
        }
    }

    private void guiInit() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (LoadModelDialog.this.tree.isSelectionEmpty()) {
                    LoadModelDialog.this.parameterWizardButton.setEnabled(false);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)LoadModelDialog.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        LoadModelDialog.this.parameterWizardButton.setEnabled(false);
                        return;
                    }
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof SimModel) {
                        LoadModelDialog.this.parameterWizardButton.setEnabled(true);
                    } else {
                        LoadModelDialog.this.parameterWizardButton.setEnabled(false);
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.load);
        jPanel.add(this.cancel);
        this.mainPanel = new JPanel(new BorderLayout());
        int n = this.btnAdd.getPreferredSize().height;
        double[][] dArrayArray = new double[][]{{4.0, 0.4, 6.0, 0.6, 4.0}, {4.0, -1.0, 2.0, n, 4.0}};
        JPanel jPanel2 = new JPanel(new TableLayout(dArrayArray));
        jPanel2.add((Component)this.btnAdd, "1, 3");
        jPanel2.add((Component)new JScrollPane(this.tree), "1, 1");
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        int n2 = this.txtParamFile.getPreferredSize().height;
        double[][] dArrayArray2 = new double[][]{{0.4, 1.0, 0.5, 4.0, 0.1}, {n2, 6.0, n2, 6.0, n2, 6.0, n2, 2.0, n2, 2.0, n2, 2.0, n2}};
        JPanel jPanel3 = new JPanel(new TableLayout(dArrayArray2));
        jPanel2.add((Component)jPanel3, "3, 1, 3, 3");
        jPanel3.add((Component)new JLabel("Name:"), "0, 0");
        jPanel3.add((Component)this.lblName, "2, 0, l, f");
        jPanel3.add((Component)new JLabel("Model Class:"), "0, 2");
        jPanel3.add((Component)this.lblModelClass, "2, 2, 4, 2");
        jPanel3.add((Component)new JLabel("Class Path:"), "0, 4");
        jPanel3.add((Component)this.lblPath, "2, 4, 4, 4");
        jPanel3.add((Component)new JLabel("Parameter File:"), "0, 6");
        jPanel3.add((Component)this.txtParamFile, "0, 8, 2, 8");
        jPanel3.add((Component)this.btnParamBrowse, "4, 8");
        jPanel3.add((Component)new JLabel("or use:"), "0, 10");
        jPanel3.add((Component)this.parameterWizardButton, "2, 10");
        jPanel3.add((Component)new JLabel("To activate the wizard, you need to select a simulation."), "0, 12, 4, 12");
        this.parameterWizardButton.setEnabled(false);
        this.mainPanel.add((Component)jPanel, "South");
        this.mainPanel.add((Component)jPanel2, "Center");
        this.btnAdd.setToolTipText("Add a class or jar file");
    }

    private void addListeners() {
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelDialog.this.selectedModel = null;
                LoadModelDialog.this.exit();
            }
        });
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelDialog.this.exit();
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getPath();
                ModelTreeNode modelTreeNode = (ModelTreeNode)treePath.getLastPathComponent();
                if (modelTreeNode.isModelNode()) {
                    LoadModelDialog.this.selectedModel = (SimModel)modelTreeNode.getUserObject();
                    LoadModelDialog.this.lblName.setText(LoadModelDialog.this.selectedModel.getName());
                    String string = LoadModelDialog.this.selectedModel.getClass().getName();
                    int n = string.lastIndexOf(".");
                    if (n != -1) {
                        string = string.substring(n + 1, string.length());
                    }
                    LoadModelDialog.this.lblModelClass.setText(string);
                    LoadModelDialog.this.txtParamFile.setText("");
                }
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName();
                        return file.isDirectory() || string.endsWith(".jar") || string.endsWith(".class");
                    }

                    public String getDescription() {
                        return "Jar and Class Files (*.jar, *.class)";
                    }
                });
                jFileChooser.setDialogType(0);
                int n = jFileChooser.showOpenDialog(LoadModelDialog.this.dialog);
                if (n == 0) {
                    SimModel simModel;
                    File file = jFileChooser.getSelectedFile();
                    if (file.getName().endsWith(".jar")) {
                        try {
                            LoadModelDialog.this.loader.addPath(file.getCanonicalPath());
                            ArrayList arrayList = LoadModelDialog.this.addSimModelFromJar(new JarFile(file));
                            for (int i = 0; i < arrayList.size(); ++i) {
                                SimModel simModel2 = (SimModel)arrayList.get(i);
                                LoadModelDialog.this.tree.addOtherModel(simModel2);
                            }
                        }
                        catch (IOException iOException) {
                            SimUtilities.showError("Error loading selected file\n" + iOException.getMessage(), iOException);
                            return;
                        }
                    } else if (file.getName().endsWith(".class") && (simModel = LoadModelDialog.this.loadClass(file, true)) != null) {
                        LoadModelDialog.this.tree.addOtherModel(simModel);
                    }
                }
            }
        });
        this.btnParamBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                String string = LoadModelDialog.this.txtParamFile.getText();
                if (string.length() > 0) {
                    jFileChooser.setCurrentDirectory(new File(string));
                }
                jFileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName();
                        return file.isDirectory() || string.endsWith(".pf");
                    }

                    public String getDescription() {
                        return "Parameter files (*.pf)";
                    }
                });
                jFileChooser.setDialogType(0);
                int n = jFileChooser.showOpenDialog(LoadModelDialog.this.dialog);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LoadModelDialog.this.txtParamFile.setText(file.getAbsolutePath());
                }
            }
        });
        this.parameterWizardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelDialog.this.displayParameterWizard();
            }
        });
    }

    private String findRepastHome(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            string2 = stringTokenizer.nextToken();
            if (!string2.endsWith(".jar") || !(file = new File(string2)).exists()) continue;
            try {
                String string3;
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (string3 = manifest.getMainAttributes().getValue("Class-Path")) == null) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if (string2.indexOf("repast.jar") != -1) {
                        if (!new File(string2).exists()) continue;
                        return string2;
                    }
                    string2 = null;
                }
            }
            catch (IOException iOException) {
            }
        }
        return string2;
    }

    private void findPaths() {
        String string = System.getProperty("java.class.path");
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).indexOf("repast.jar") == -1) {
            string2 = null;
        }
        if (string2 == null && (string2 = this.findRepastHome(string)) == null) {
            SimUtilities.showMessage("Cannot find repast home directory");
            return;
        }
        File file = new File(string2);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            SimUtilities.showMessage("Cannot find repast home directory");
            return;
        }
        string2 = file.getParent();
        File file2 = new File(string2 + File.separator + "models");
        if (file2.exists()) {
            this.modelsDir = file2.getAbsolutePath();
        }
        file2 = new File(string2 + File.separator + "demo");
        if (file2.exists()) {
            this.demoDir = file2.getAbsolutePath();
        } else {
            file2 = new File(string2 + File.separator + "demos");
            if (file2.exists()) {
                this.demoDir = file2.getAbsolutePath();
            }
        }
    }

    private void loadDemos() throws IOException {
        File file = new File(this.demoDir);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getSimModels(file));
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.addAll(this.getSimModels(fileArray[i]));
        }
        Collections.sort(arrayList, this.modelComp);
        this.tree.addDemos(arrayList);
    }

    private void loadModels() throws IOException {
        File file = new File(this.modelsDir);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getSimModels(file));
        this.findClasses(new File(this.modelsDir).listFiles(), arrayList);
        Collections.sort(arrayList, this.modelComp);
        this.tree.addModels(arrayList);
    }

    private void findClasses(File[] fileArray, ArrayList arrayList) {
        for (int i = 0; i < fileArray.length; ++i) {
            SimModel simModel;
            File file = fileArray[i];
            if (file.isDirectory()) {
                this.findClasses(file.listFiles(), arrayList);
                continue;
            }
            if (!file.getName().endsWith(".class") || (simModel = this.loadClass(file, false)) == null) continue;
            arrayList.add(simModel);
        }
    }

    private ArrayList getSimModels(File file) throws IOException {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        });
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            this.loader.addPath(fileArray[i].getAbsolutePath());
            JarFile jarFile = new JarFile(fileArray[i]);
            arrayList.addAll(this.addSimModelFromJar(jarFile));
        }
        return arrayList;
    }

    private SimModel loadClass(File file, boolean bl) {
        try {
            Disassembler disassembler = new Disassembler(file);
            String string = disassembler.getFQClassName().replace('/', '.');
            String string2 = string.replace('.', File.separatorChar);
            String string3 = file.getAbsolutePath();
            int n = string3.lastIndexOf(string2);
            if (n != -1) {
                string3 = string3.substring(0, n);
                this.loader.addPath(string3);
                Class<?> clazz = this.loader.loadClass(string);
                if (this.isSimModel(clazz)) {
                    return (SimModel)clazz.newInstance();
                }
                if (bl) {
                    SimUtilities.showMessage(string + " is not a SimModel");
                }
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error loading selected file\n" + iOException.getMessage(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SimUtilities.showError("Error loading selected file\n" + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error loading selected file\n" + instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error loading selected file\n" + illegalAccessException.getMessage(), illegalAccessException);
        }
        return null;
    }

    private ArrayList addSimModelFromJar(JarFile jarFile) throws IOException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        ArrayList<SimModel> arrayList = new ArrayList<SimModel>();
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (object3 = ((Attributes)(object2 = manifest.getMainAttributes())).getValue("Class-Path")) != null) {
            object = new StringTokenizer((String)object3, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                serializable = new File(((StringTokenizer)object).nextToken());
                this.loader.addPath(((File)serializable).getCanonicalPath());
            }
        }
        object2 = jarFile.entries();
        while (object2.hasMoreElements()) {
            object3 = (ZipEntry)object2.nextElement();
            if (!((ZipEntry)object3).getName().endsWith(".class")) continue;
            object = ((ZipEntry)object3).getName().substring(0, ((ZipEntry)object3).getName().length() - 6);
            if (this.demoExclude.contains(object = ((String)object).replace('/', '.'))) continue;
            try {
                serializable = this.loader.loadClass((String)object);
                if (!this.isSimModel((Class)serializable)) continue;
                SimModel simModel = (SimModel)((Class)serializable).newInstance();
                arrayList.add(simModel);
            }
            catch (ClassNotFoundException classNotFoundException) {
                SimUtilities.showError("Error loading jar " + jarFile.getName() + "\n" + classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                SimUtilities.showError("Error loading jar " + jarFile.getName() + "\n" + instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Error loading jar " + jarFile.getName() + "\n" + illegalAccessException.getMessage(), illegalAccessException);
            }
        }
        return arrayList;
    }

    private boolean isSimModel(Class clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        while (clazz != null) {
            if (this.simModelCheck(clazz)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private boolean simModelCheck(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals("uchicago.src.sim.engine.SimModel")) continue;
            return true;
        }
        return false;
    }

    private void exit() {
        this.dialog.dispose();
    }

    public void display(JFrame jFrame) {
        this.dialog = new JDialog(jFrame, "Load Model", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadModelDialog.this.selectedModel = null;
                LoadModelDialog.this.exit();
            }
        });
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.dialog.setSize(500, 308);
        GuiUtilities.centerComponentOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    public SimModel getModel() {
        Class<?> clazz = null;
        if (this.selectedModel != null) {
            try {
                clazz = this.selectedModel.getClass();
                this.selectedModel = (SimModel)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                SimUtilities.showError("Error loading class " + clazz.getName() + "\n" + instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Error loading class " + clazz.getName() + "\n" + illegalAccessException.getMessage(), illegalAccessException);
            }
        }
        return this.selectedModel;
    }

    public String getParameterFile() {
        return this.txtParamFile.getText();
    }

    public void setParameterFile(String string) {
        this.txtParamFile.setText(string);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    private void displayParameterWizard() {
        ParameterWizard parameterWizard = new ParameterWizard(this);
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            ParameterData parameterData = null;
            if (this.txtParamFile.getText() != null && !this.txtParamFile.getText().equals("")) {
                try {
                    parameterData = new ParameterData(this.txtParamFile.getText());
                }
                catch (Exception exception) {
                    SimUtilities.showError("Error loading parameters from " + this.txtParamFile.getText() + "\n" + exception.getMessage() + "\n\nWill initialize using model information.", exception);
                    parameterData = new ParameterData();
                    bl = true;
                }
            } else {
                parameterData = new ParameterData();
                bl = true;
            }
            if (bl) {
                Object object = defaultMutableTreeNode.getUserObject();
                parameterData = new ParameterData((SimModel)object);
            }
            parameterData.reloadInputOutput();
            parameterWizard.setAParameterData(parameterData);
            parameterWizard.display();
        }
    }

    class CLoader
    extends URLClassLoader {
        public CLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public Class createClass(byte[] byArray, int n, int n2) {
            return super.defineClass(null, byArray, n, n2);
        }

        public void addPath(String string) throws MalformedURLException {
            File file = new File(string);
            this.addURL(file.toURL());
        }
    }

    class ModelComparator
    implements Comparator {
        ModelComparator() {
        }

        public int compare(Object object, Object object2) {
            SimModel simModel = (SimModel)object;
            SimModel simModel2 = (SimModel)object2;
            return simModel.getName().compareTo(simModel2.getName());
        }
    }
}

