/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.analysis.NetSeqTableRow;
import uchicago.src.sim.analysis.NetSequenceSetupPanel;
import uchicago.src.sim.analysis.OpenSequenceGraph;
import uchicago.src.sim.analysis.Sequence;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.network.NetUtilities;

public class NetSequenceGraph
extends OpenSequenceGraph {
    private List nodeList;
    private HashMap tableRows = new HashMap();
    private static final Integer CLUSTER = new Integer(0);
    private static final Integer DENSITY = new Integer(1);
    private static final Integer DIAMETER = new Integer(2);
    private static final Integer COMPONENT = new Integer(3);
    private static final Integer PATH_LENGTH = new Integer(4);
    private static final Integer SYMMETRY = new Integer(5);

    public NetSequenceGraph(String string, SimModel simModel, List list) {
        super(string, simModel);
        this.nodeList = list;
        this.makeTableRows();
    }

    public NetSequenceGraph(String string, SimModel simModel, String string2, int n, List list) {
        super(string, simModel, string2, n);
        this.nodeList = list;
        this.makeTableRows();
    }

    private void makeTableRows() {
        Sequence sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.calcClustCoef(NetSequenceGraph.this.nodeList);
            }
        };
        NetSeqTableRow netSeqTableRow = new NetSeqTableRow("Clust Coef", sequence, Color.red);
        this.tableRows.put(CLUSTER, netSeqTableRow);
        sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.calcDensity(NetSequenceGraph.this.nodeList);
            }
        };
        netSeqTableRow = new NetSeqTableRow("Density", sequence, Color.green);
        this.tableRows.put(DENSITY, netSeqTableRow);
        sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.calcDiameter(NetSequenceGraph.this.nodeList);
            }
        };
        netSeqTableRow = new NetSeqTableRow("Diameter", sequence, Color.blue);
        this.tableRows.put(DIAMETER, netSeqTableRow);
        sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.getComponents(NetSequenceGraph.this.nodeList).size();
            }
        };
        netSeqTableRow = new NetSeqTableRow("Components", sequence, Color.magenta);
        this.tableRows.put(COMPONENT, netSeqTableRow);
        sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.calcAvgPathLength(NetSequenceGraph.this.nodeList);
            }
        };
        netSeqTableRow = new NetSeqTableRow("Avg. Path Length", sequence, Color.black);
        this.tableRows.put(PATH_LENGTH, netSeqTableRow);
        sequence = new Sequence(){

            public double getSValue() {
                return NetUtilities.calcSymmetry(NetSequenceGraph.this.nodeList);
            }
        };
        netSeqTableRow = new NetSeqTableRow("Symmetry", sequence, Color.orange);
        this.tableRows.put(SYMMETRY, netSeqTableRow);
    }

    public void display() {
        if (this.frame == null) {
            this.frame = FrameFactory.createFrame(this.title);
            this.frame.setDefaultCloseOperation(2);
            this.frame.getContentPane().setLayout(new BorderLayout());
            final JTabbedPane jTabbedPane = new JTabbedPane();
            this.frame.getContentPane().add((Component)jTabbedPane, "Center");
            jTabbedPane.add("Plot", this.plot);
            ArrayList arrayList = new ArrayList(this.tableRows.values());
            NetSequenceSetupPanel netSequenceSetupPanel = new NetSequenceSetupPanel(arrayList);
            jTabbedPane.add("Setup", netSequenceSetupPanel);
            this.frame.setTitle(this.title);
            jTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (jTabbedPane.getSelectedIndex() == 0) {
                        NetSequenceGraph.this.checkAddSequences();
                    }
                }
            });
            this.frame.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (!NetSequenceGraph.this.inNormalState && n == 82) {
                        NetSequenceGraph.this.plot.setYRange(NetSequenceGraph.this.yMin, NetSequenceGraph.this.yMax);
                        NetSequenceGraph.this.plot.setXRange(NetSequenceGraph.this.xMin, NetSequenceGraph.this.xMax);
                        NetSequenceGraph.this.inNormalState = true;
                        NetSequenceGraph.this.plot.repaint();
                    }
                }
            });
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowDeiconified(WindowEvent windowEvent) {
                    NetSequenceGraph.this.updateGraph();
                }
            });
            this.frame.pack();
            Rectangle rectangle = FrameFactory.getBounds(this.title);
            if (this.location != null) {
                this.frame.setLocation(this.location);
                if (rectangle != null) {
                    this.frame.setSize(rectangle.width, rectangle.height);
                }
            } else if (rectangle != null) {
                this.frame.setBounds(rectangle);
            } else {
                GuiUtilities.centerComponentOnScreen(this.frame);
            }
            this.frame.setVisible(true);
        }
    }

    private void checkAddSequences() {
        Iterator iterator = this.tableRows.values().iterator();
        while (iterator.hasNext()) {
            NetSeqTableRow netSeqTableRow = (NetSeqTableRow)iterator.next();
            netSeqTableRow.addSequence(this);
        }
        this.step();
    }

    private NetSeqTableRow getTableRow(Integer n) {
        return (NetSeqTableRow)this.tableRows.get(n);
    }

    public void plotDensity(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DENSITY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotDensity(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DENSITY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotDensity(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DENSITY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotDensity(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DENSITY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }

    public void plotComponentCount(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(COMPONENT);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotComponentCount(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(COMPONENT);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotComponentCount(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(COMPONENT);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotComponentCount(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(COMPONENT);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }

    public void plotClusterCoefficient(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(CLUSTER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotClusterCoefficient(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(CLUSTER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotClusterCoefficient(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(CLUSTER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotClusterCoefficient(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(CLUSTER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }

    public void plotDiameter(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DIAMETER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotDiameter(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DIAMETER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotDiameter(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DIAMETER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotDiameter(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(DIAMETER);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }

    public void plotAvgPathLength(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(PATH_LENGTH);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotAvgPathLength(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(PATH_LENGTH);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotAvgPathLength(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(PATH_LENGTH);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotAvgPathLength(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(PATH_LENGTH);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }

    public void plotSymmetry(String string) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(SYMMETRY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string);
    }

    public void plotSymmetry(String string, Color color) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(SYMMETRY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color);
    }

    public void plotSymmetry(String string, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(SYMMETRY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, n);
    }

    public void plotSymmetry(String string, Color color, int n) {
        NetSeqTableRow netSeqTableRow = this.getTableRow(SYMMETRY);
        netSeqTableRow.setShow(true);
        netSeqTableRow.addSequence(this, string, color, n);
    }
}

