/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import uchicago.src.sim.analysis.BlockFileWriter;
import uchicago.src.sim.analysis.DataFileHeader;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.util.SimUtilities;

public class ExcelFileWriter
implements BlockFileWriter {
    private HSSFWorkbook book;
    private boolean isBatch = false;
    private String fileName;
    private String blockHeader = "";
    private boolean initialized = false;
    private HashSet sheetsHeadersWritten = new HashSet();
    private Hashtable sheetsCurRow;
    private DataFileHeader dfHeader;
    private FileOutputStream out;

    public ExcelFileWriter(String string, DataFileHeader dataFileHeader) {
        try {
            this.fileName = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Fatal file Error", iOException);
            System.exit(0);
        }
        this.dfHeader = dataFileHeader;
        if (dataFileHeader.isBatch()) {
            this.sheetsCurRow = (Hashtable)dataFileHeader.getPersistentObj(this.fileName);
            if (this.sheetsCurRow == null) {
                this.sheetsCurRow = new Hashtable();
                dataFileHeader.putPersistentObj(this.fileName, this.sheetsCurRow);
            }
        } else {
            this.sheetsCurRow = new Hashtable();
        }
    }

    public void setBlockHeader(String string) {
        this.blockHeader = string;
    }

    private void init() {
        try {
            this.renameFile();
            this.openBook();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error opening excel file", iOException);
            System.exit(0);
        }
        this.initialized = true;
    }

    private void openBook() {
        this.book = new HSSFWorkbook();
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            if (this.isBatch) {
                string = string + ".bak";
            }
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }

    private void writeHeader(String string) {
        HSSFSheet hSSFSheet = this.book.createSheet(string);
        HSSFRow hSSFRow = null;
        HSSFCell hSSFCell = null;
        String string2 = this.dfHeader.getFileHeader();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            hSSFRow = hSSFSheet.createRow((short)n);
            if (string3.indexOf(58) != -1) {
                int n2 = string3.indexOf(58);
                hSSFCell = hSSFRow.createCell((short)0);
                hSSFCell.setCellValue(string3.substring(0, n2));
                hSSFCell = hSSFRow.createCell((short)1);
                hSSFCell.setCellValue(string3.substring(n2 + 1, string3.length()));
            } else {
                hSSFCell = hSSFRow.createCell((short)0);
                hSSFCell.setCellValue(stringTokenizer.nextToken());
            }
            ++n;
        }
        this.sheetsHeadersWritten.add(string);
        this.sheetsCurRow.put(string, new Integer(++n));
    }

    private void writeData(String string, AdjacencyMatrix adjacencyMatrix) {
        int n;
        Object object;
        int n2 = (Integer)this.sheetsCurRow.get(string);
        HSSFSheet hSSFSheet = this.book.getSheet(string);
        String string2 = this.blockHeader + "\n" + this.dfHeader.getBlockHeader();
        HSSFRow hSSFRow = null;
        HSSFCell hSSFCell = null;
        if (string2.trim().length() > 0) {
            object = new StringTokenizer(string2, "\r\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                hSSFRow = hSSFSheet.createRow((short)n2);
                if (string3.indexOf(58) != -1) {
                    n = string3.indexOf(58);
                    hSSFCell = hSSFRow.createCell((short)0);
                    hSSFCell.setCellValue(string3.substring(0, n));
                    hSSFCell = hSSFRow.createCell((short)1);
                    hSSFCell.setCellValue(string3.substring(n + 1, string3.length()));
                } else {
                    hSSFCell = hSSFRow.createCell((short)0);
                    hSSFCell.setCellValue(string3);
                }
                ++n2;
            }
        }
        if (adjacencyMatrix.getLabels().size() > 0) {
            int n3;
            hSSFRow = hSSFSheet.createRow((short)n2);
            object = new Vector(adjacencyMatrix.getLabels());
            for (n3 = 1; n3 <= ((Vector)object).size(); ++n3) {
                hSSFCell = hSSFRow.createCell((short)n3);
                hSSFCell.setCellValue((String)((Vector)object).get(n3 - 1));
            }
            for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                hSSFRow = hSSFSheet.createRow((short)(n2 + n3 + 1));
                hSSFCell = hSSFRow.createCell((short)0);
                hSSFCell.setCellValue((String)((Vector)object).get(n3));
            }
            ++n2;
        }
        for (int i = 0; i < adjacencyMatrix.rows(); ++i) {
            double[] dArray = adjacencyMatrix.getRow(i).toArray();
            hSSFRow = hSSFSheet.getRow((int)((short)n2));
            hSSFCell = hSSFRow.createCell((short)1);
            for (n = 0; n < dArray.length; ++n) {
                hSSFCell.setCellValue(dArray[n]);
                hSSFCell = hSSFRow.createCell((short)(n + 1));
            }
            ++n2;
        }
        this.sheetsCurRow.put(string, new Integer(++n2));
    }

    public void writeToFile(Object object) {
        if (!(object instanceof AdjacencyMatrix)) {
            throw new IllegalArgumentException("Argument to ExcelFileWriter.writeToFile() must be an AdjacencyMatrix");
        }
        if (this.dfHeader.isBatch()) {
            if (this.dfHeader.doWriteHeader(this.fileName)) {
                this.init();
                this.dfHeader.setWriteHeader(this.fileName, false);
            }
        } else if (!this.initialized) {
            this.init();
        }
        String string = "Sheet1";
        AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)object;
        String string2 = adjacencyMatrix.getMatrixLabel();
        if (string2.trim().length() > 0) {
            string = string2;
        }
        if (this.dfHeader.isBatch()) {
            if (this.dfHeader.doWriteHeader(this.fileName + string)) {
                this.writeHeader(string);
                this.dfHeader.setWriteHeader(this.fileName + string, false);
            } else {
                this.book.createSheet(string);
            }
        } else if (!this.sheetsHeadersWritten.contains(string)) {
            this.writeHeader(string);
        }
        this.writeData(string, adjacencyMatrix);
        try {
            this.out = new FileOutputStream(this.fileName);
            this.book.write((OutputStream)this.out);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Excel Writer Error: " + iOException, iOException);
        }
    }

    public void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            SimUtilities.showError("Excel Writer Error: " + iOException, iOException);
            System.exit(0);
        }
    }
}

