/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.reflector;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import uchicago.src.reflector.BooleanPropertyDescriptor;
import uchicago.src.reflector.Introspector;
import uchicago.src.reflector.PropertyButton;
import uchicago.src.reflector.PropertyDescriptor;
import uchicago.src.reflector.PropertyLabel;
import uchicago.src.reflector.PropertyTextField;
import uchicago.src.reflector.PropertyWidget;
import uchicago.src.reflector.WidgetInfo;

public class WidgetFactory {
    private Introspector spector;
    private List valueFields;
    private Map descriptors;

    public WidgetFactory(Introspector introspector, List list, Map map) {
        this.spector = introspector;
        this.valueFields = list;
        this.descriptors = map;
    }

    public PropertyWidget getWidget(String string) throws IllegalAccessException, InvocationTargetException {
        if (this.spector.isWriteOnly(string)) {
            return this.getWriteOnlyWidget();
        }
        boolean bl = this.spector.isPropertyStringable(string);
        boolean bl2 = this.spector.isReadOnly(string);
        if (bl && bl2) {
            return this.getStringableReadOnlyWidget(string);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.descriptors.get(string);
        if (propertyDescriptor != null) {
            return this.getPropertyDescriptorWidget(propertyDescriptor, string);
        }
        if (this.spector.isPropertyBoolean(string)) {
            return this.getBooleanWidget(string);
        }
        if (bl) {
            return this.getSimpleLabelWidget(string);
        }
        if (this.hasWidgetInfo(string)) {
            return this.getWidgetInfoPropertyWidget(string);
        }
        if (this.spector.getPropertyValue(string) == null) {
            PropertyLabel propertyLabel = new PropertyLabel("Null");
            this.valueFields.add(propertyLabel);
            return propertyLabel;
        }
        return this.getPropertyButtonWidget(string, bl2);
    }

    private PropertyWidget getWidgetInfoPropertyWidget(String string) throws IllegalAccessException, InvocationTargetException {
        PropertyWidget propertyWidget;
        Class clazz = this.spector.getPropertyClass(string);
        try {
            Class<?> clazz2 = Class.forName(clazz.getName() + "WidgetInfo");
            WidgetInfo widgetInfo = (WidgetInfo)clazz2.newInstance();
            propertyWidget = widgetInfo.getPropertyWidget();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("WidgetInfo for '" + string + "' not found.");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to instantiate WidgetInfo for '" + string + "' not found.");
        }
        propertyWidget.setValue(this.spector.getPropertyValue(string));
        this.valueFields.add(propertyWidget);
        return propertyWidget;
    }

    private boolean hasWidgetInfo(String string) {
        Class clazz = this.spector.getPropertyClass(string);
        try {
            Class.forName(clazz.getName() + "WidgetInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private PropertyWidget getPropertyButtonWidget(String string, boolean bl) throws IllegalAccessException, InvocationTargetException {
        PropertyButton propertyButton = new PropertyButton(this.spector.getPropertyValue(string), !bl);
        this.valueFields.add(propertyButton);
        return propertyButton;
    }

    private PropertyWidget getSimpleLabelWidget(String string) throws IllegalAccessException, InvocationTargetException {
        PropertyTextField propertyTextField = new PropertyTextField(8);
        propertyTextField.setValue(this.spector.getPropertyValue(string));
        this.valueFields.add(propertyTextField);
        return propertyTextField;
    }

    private PropertyWidget getPropertyDescriptorWidget(PropertyDescriptor propertyDescriptor, String string) throws IllegalAccessException, InvocationTargetException {
        PropertyWidget propertyWidget = propertyDescriptor.getWidget();
        propertyWidget.setValue(this.spector.getPropertyValue(string));
        this.valueFields.add(propertyWidget);
        return propertyWidget;
    }

    private PropertyWidget getBooleanWidget(String string) throws IllegalAccessException, InvocationTargetException {
        PropertyWidget propertyWidget = new BooleanPropertyDescriptor(string, true).getWidget();
        propertyWidget.setValue(this.spector.getPropertyValue(string));
        this.valueFields.add(propertyWidget);
        return propertyWidget;
    }

    private PropertyWidget getStringableReadOnlyWidget(String string) throws IllegalAccessException, InvocationTargetException {
        String string2 = this.spector.getPropertyAsString(string);
        PropertyLabel propertyLabel = new PropertyLabel(string2);
        propertyLabel.setPropertyName(string);
        this.valueFields.add(propertyLabel);
        return propertyLabel;
    }

    private PropertyWidget getWriteOnlyWidget() {
        return new PropertyLabel("Is Write-only");
    }
}

