/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.collection;

import cern.colt.matrix.impl.DenseDoubleMatrix1D;

public class ByteMatrix2D {
    private byte[] matrix;
    private int rows;
    private int cols;

    public ByteMatrix2D(int n, int n2) {
        this.matrix = new byte[n * n2];
        this.rows = n;
        this.cols = n2;
    }

    public ByteMatrix2D(byte[][] byArray) {
        this.rows = byArray.length;
        this.cols = byArray.length == 0 ? 0 : byArray[0].length;
        this.matrix = new byte[this.rows * this.cols];
        for (int i = 0; i < this.rows; ++i) {
            byte[] byArray2 = byArray[i];
            System.arraycopy(byArray2, 0, this.matrix, i * this.cols, this.cols);
        }
    }

    public DenseDoubleMatrix1D getRow(int n) {
        double[] dArray = new double[this.cols];
        int n2 = n * this.cols;
        for (int i = 0; i < this.cols; ++i) {
            dArray[i] = this.matrix[n2 + i];
        }
        return new DenseDoubleMatrix1D(dArray);
    }

    public void set(int n, int n2, byte by) {
        this.matrix[n * this.cols + n2] = by;
    }

    public byte get(int n, int n2) {
        return this.matrix[n * this.cols + n2];
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.cols;
    }

    public double zSum() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            d += (double)this.matrix[i];
        }
        return d;
    }

    public ByteMatrix2D copy() {
        ByteMatrix2D byteMatrix2D = new ByteMatrix2D(this.rows, this.cols);
        System.arraycopy(this.matrix, 0, byteMatrix2D.matrix, 0, this.matrix.length);
        return byteMatrix2D;
    }

    public ByteMatrix2D zMult(ByteMatrix2D byteMatrix2D) {
        int n = this.rows;
        int n2 = this.cols;
        int n3 = byteMatrix2D.cols;
        if (byteMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions do not agree");
        }
        ByteMatrix2D byteMatrix2D2 = new ByteMatrix2D(this.rows, this.cols);
        int n4 = n3;
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                byte by = 0;
                int n6 = n2;
                while (--n6 >= 0) {
                    by = (byte)(by + this.matrix[n5 * this.cols + n6] * byteMatrix2D.get(n6, n4));
                }
                byteMatrix2D2.set(n5, n4, (byte)(by + byteMatrix2D2.get(n5, n4)));
            }
        }
        return byteMatrix2D2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rows);
        stringBuffer.append(" x ");
        stringBuffer.append(this.cols);
        stringBuffer.append("\n");
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (j != 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.matrix[i * this.cols + j]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ByteMatrix2D byteMatrix2D = new ByteMatrix2D(6, 6);
        byteMatrix2D.set(0, 1, (byte)1);
        byteMatrix2D.set(0, 4, (byte)1);
        byteMatrix2D.set(1, 2, (byte)1);
        byteMatrix2D.set(1, 5, (byte)1);
        byteMatrix2D.set(2, 1, (byte)1);
        byteMatrix2D.set(3, 4, (byte)1);
        byteMatrix2D.set(4, 5, (byte)1);
        byteMatrix2D.set(5, 1, (byte)1);
        System.out.println("x:");
        System.out.println(byteMatrix2D);
        ByteMatrix2D byteMatrix2D2 = byteMatrix2D.zMult(byteMatrix2D);
        System.out.println("x2:");
        System.out.println(byteMatrix2D2);
        ByteMatrix2D byteMatrix2D3 = byteMatrix2D.zMult(byteMatrix2D2);
        System.out.println("x3:");
        System.out.println(byteMatrix2D3);
    }
}

