/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecExpr;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDecExpr;
import ilog.solver.IlcDemon;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.iv;
import ilog.solver.nm;
import ilog.solver.pq;
import ilog.solver.sv;

final class wc
extends IlcConstraint {
    protected IlcDecExpr _v;
    protected IlcNumExpr _exp;

    wc(IloDecExpr iloDecExpr, IloNumExpr iloNumExpr) {
        this._v = (IlcDecExpr)iloDecExpr;
        this._exp = (IlcNumExpr)iloNumExpr;
    }

    public IlcDecExpr getDecExpr() {
        return this._v;
    }

    public IlcNumExpr getNumExpr() {
        return this._exp;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._v.getPNumExp(ilcSolver);
        if (nm2 instanceof sv) {
            sv sv2 = (sv)nm2;
            nm nm3 = this._exp.getPNumExp(ilcSolver);
            return new lh(sv2, nm3);
        }
        iv iv2 = (iv)nm2;
        nm nm4 = this._exp.getPNumExp(ilcSolver);
        return new cj(iv2, nm4);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("decLeRound(");
        stringBuffer.append(this._v);
        stringBuffer.append(",");
        stringBuffer.append(this._exp);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.leRound((IloDecExpr)iloCopyManager.getCopy(this._v), (IloNumExpr)iloCopyManager.getCopy(this._exp));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._v.needCopy(check);
        this._exp.needCopy(check);
    }

    static class cj
    extends IlcPPropagator {
        final iv kt;
        final nm lt;

        public cj(iv iv2, nm nm2) {
            this.kt = iv2;
            this.lt = nm2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.lt.whenRange(ilcDemon);
        }

        public void post() {
            this.lt.whenRange(this);
        }

        public void propagate() {
            this.lt.setDomainLB(this.kt.getDomainRoundLB());
        }

        public boolean isViolated() {
            return this.lt.getDomainUB() < this.kt.getDomainRoundLB();
        }

        public IlcPPropagator makeOpposite() {
            return new pq.rm(this.kt, this.lt);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("decLeRound PLeCstRound(");
            stringBuffer.append(this.kt);
            stringBuffer.append(",");
            stringBuffer.append(this.lt);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    static final class lh
    extends IlcPPropagator {
        final sv yp;
        final nm zp;

        public lh(sv sv2, nm nm2) {
            this.yp = sv2;
            this.zp = nm2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.yp.whenRange(ilcDemon);
            this.zp.whenRange(ilcDemon);
        }

        public void post() {
            this.yp.whenRange(this);
            this.zp.whenRange(this);
        }

        public void propagate() {
            this.yp.setDomainRoundUB(this.zp.getDomainUB());
            this.zp.setDomainLB(this.yp.getDomainRoundLB());
        }

        public boolean isViolated() {
            return this.zp.getDomainUB() < this.yp.getDomainRoundLB();
        }

        public IlcPPropagator makeOpposite() {
            return new pq.kd(this.yp, this.zp);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("decLeRound PLeRound(");
            stringBuffer.append(this.yp);
            stringBuffer.append(",");
            stringBuffer.append(this.zp);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

