/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.hy;
import ilog.solver.nm;

final class me
extends hy {
    final nm th;
    final double uh;
    final double vh;
    final double wh;
    final boolean xh;

    public me(nm nm2, int n2) {
        this.th = nm2;
        this.uh = n2;
        this.vh = IlcFloat.roundDown(1.0 / this.uh);
        this.wh = IlcFloat.roundUp(1.0 / this.uh);
        this.xh = (n2 & 1) == 1;
        nm2.isUsed(this);
    }

    public IlcSolver getSolver() {
        return this.th.getSolver();
    }

    protected hg[] getArgs() {
        return new hg[]{this.th};
    }

    protected void computeRange() {
        double d2 = this.th.getDomainLB();
        double d3 = this.th.getDomainUB();
        if (this.th.in()) {
            this.setNaN();
            return;
        }
        if (this.xh) {
            if (d2 >= 0.0) {
                this.bzb = IlcFloat.posPowerDown(d2, this.uh);
                this.czb = IlcFloat.posPowerUp(d3, this.uh);
            } else if (d3 <= 0.0) {
                this.bzb = -IlcFloat.posPowerUp(-d2, this.uh);
                this.czb = -IlcFloat.posPowerDown(-d3, this.uh);
            } else {
                this.bzb = -IlcFloat.posPowerUp(-d2, this.uh);
                this.czb = IlcFloat.posPowerUp(d3, this.uh);
            }
        } else if (d2 >= 0.0) {
            this.bzb = IlcFloat.posPowerDown(d2, this.uh);
            this.czb = IlcFloat.posPowerUp(d3, this.uh);
        } else if (d3 <= 0.0) {
            this.bzb = IlcFloat.posPowerDown(-d3, this.uh);
            this.czb = IlcFloat.posPowerUp(-d2, this.uh);
        } else {
            double d4 = Math.max(-d2, d3);
            this.bzb = 0.0;
            this.czb = IlcFloat.posPowerUp(d4, this.uh);
        }
    }

    protected void setRangeInternal(double d2, double d3) {
        if (this.xh) {
            if (d2 >= 0.0) {
                this.th.setDomainRange(IlcFloat.posPowerDown(d2, this.vh, this.wh), IlcFloat.posPowerUp(d3, this.vh, this.wh));
            } else if (d3 <= 0.0) {
                this.th.setDomainRange(-IlcFloat.posPowerUp(-d2, this.vh, this.wh), -IlcFloat.posPowerDown(-d3, this.vh, this.wh));
            } else {
                this.th.setDomainRange(-IlcFloat.posPowerUp(-d2, this.vh, this.wh), IlcFloat.posPowerUp(d3, this.vh, this.wh));
            }
        } else {
            double d4;
            if (d2 > 0.0) {
                d4 = IlcFloat.posPowerDown(d2, this.vh, this.wh);
                double d5 = this.th.getDomainLB();
                double d6 = this.th.getDomainUB();
                if (Math.abs(d5) < d4) {
                    this.th.setDomainLB(d4);
                }
                if (Math.abs(d6) < d4) {
                    this.th.setDomainUB(-d4);
                }
            }
            if (d3 >= 0.0) {
                d4 = IlcFloat.posPowerUp(d3, this.vh, this.wh);
                this.th.setDomainRange(-d4, d4);
            } else {
                this.fail();
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.th);
        stringBuffer.append("^");
        stringBuffer.append(this.uh);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

