/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloRange;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcNumScalProd;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.er;
import ilog.solver.kf;
import ilog.solver.kl;
import ilog.solver.mk;
import ilog.solver.nm;
import ilog.solver.qe;
import ilog.solver.rq;
import ilog.solver.ym;
import ilog.solver.yv;

public class IlcRange
extends IlcConstraint
implements IloRange {
    double flb;
    IlcNumExpr glb;
    double hlb;

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this.glb.getPNumExp(ilcSolver);
        if (Double.isNaN(this.flb) || Double.isNaN(this.hlb)) {
            return new kl(ilcSolver);
        }
        if (this.flb == Double.NEGATIVE_INFINITY && this.hlb == Double.POSITIVE_INFINITY) {
            return new kf(ilcSolver);
        }
        if (this.flb == Double.NEGATIVE_INFINITY) {
            if (this.hlb == 0.0 && this.glb instanceof IlcNumScalProd) {
                IlcNumScalProd ilcNumScalProd = (IlcNumScalProd)this.glb;
                if (ilcNumScalProd.isADifference()) {
                    nm nm3 = ilcNumScalProd.positiveTermOfDifference().getPNumExp(ilcSolver);
                    nm nm4 = ilcNumScalProd.negativeTermOfDifference().getPNumExp(ilcSolver);
                    return new ym(nm3, nm4);
                }
                return new qe(nm2, this.hlb);
            }
            return new qe(nm2, this.hlb);
        }
        if (this.hlb == Double.POSITIVE_INFINITY) {
            if (this.flb == 0.0 && this.glb instanceof IlcNumScalProd) {
                IlcNumScalProd ilcNumScalProd = (IlcNumScalProd)this.glb;
                if (ilcNumScalProd.isADifference()) {
                    nm nm5 = ilcNumScalProd.positiveTermOfDifference().getPNumExp(ilcSolver);
                    nm nm6 = ilcNumScalProd.negativeTermOfDifference().getPNumExp(ilcSolver);
                    return new rq(nm5, nm6);
                }
                return new mk(nm2, this.flb);
            }
            return new mk(nm2, this.flb);
        }
        if (this.flb == this.hlb) {
            if (this.flb == 0.0 && this.glb instanceof IlcNumScalProd) {
                IlcNumScalProd ilcNumScalProd = (IlcNumScalProd)this.glb;
                if (ilcNumScalProd.isADifference()) {
                    nm nm7 = ilcNumScalProd.positiveTermOfDifference().getPNumExp(ilcSolver);
                    nm nm8 = ilcNumScalProd.negativeTermOfDifference().getPNumExp(ilcSolver);
                    return new er(nm7, nm8);
                }
                return new yv(nm2, this.flb);
            }
            return new yv(nm2, this.flb);
        }
        return new ku(this.flb, nm2, this.hlb);
    }

    public IlcRange(double d2, IlcNumExpr ilcNumExpr, double d3, String string) {
        super(string);
        this.flb = d2;
        this.glb = ilcNumExpr;
        this.hlb = d3;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.flb == this.hlb) {
            stringBuffer.append(this.glb);
            stringBuffer.append(" == ");
            stringBuffer.append(this.hlb);
        } else {
            if (this.flb > Double.NEGATIVE_INFINITY) {
                stringBuffer.append(this.flb);
                stringBuffer.append(" <= ");
            }
            stringBuffer.append(this.glb);
            if (this.hlb < Double.POSITIVE_INFINITY) {
                stringBuffer.append(" <= ");
                stringBuffer.append(this.hlb);
            }
        }
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        IloRange iloRange = iloModeler.range(this.flb, (IloNumExpr)iloCopyManager.getCopy(this.glb), this.hlb);
        iloRange.setName(this.getName());
        return iloRange;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this.glb.needCopy(check);
    }

    public double getLB() throws IloException {
        return this.flb;
    }

    public double getUB() throws IloException {
        return this.hlb;
    }

    public void setLB(double d2) throws IloException {
        this.flb = d2;
    }

    public void setUB(double d2) throws IloException {
        this.hlb = d2;
    }

    public void setBounds(double d2, double d3) throws IloException {
        this.flb = d2;
        this.hlb = d3;
    }

    public IloNumExpr getExpr() throws IloException {
        return this.glb;
    }

    public void setExpr(IloNumExpr iloNumExpr) throws IloException {
        this.glb = (IlcNumExpr)iloNumExpr;
    }

    public void clearExpr() throws IloException {
        this.glb = null;
    }

    static final class ku
    extends IlcPPropagator {
        final double hqb;
        final nm iqb;
        final double jqb;

        public ku(double d2, nm nm2, double d3) {
            this.hqb = d2;
            this.iqb = nm2;
            this.jqb = d3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.iqb.whenRange(ilcDemon);
        }

        public void post() {
            if (!this.iqb.jn()) {
                this.iqb.whenRange(this);
            }
        }

        public void propagate() {
            this.iqb.setDomainRange(this.hqb, this.jqb);
        }

        public boolean isViolated() {
            double d2 = this.iqb.getDomainLB();
            double d3 = this.iqb.getDomainUB();
            if (this.iqb.in()) {
                return true;
            }
            return d3 < this.hqb || d2 > this.jqb;
        }

        public IlcPPropagator makeOpposite() {
            return new ld(this.hqb, this.iqb, this.jqb);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.hqb == this.jqb) {
                stringBuffer.append(this.iqb);
                stringBuffer.append(" == ");
                stringBuffer.append(this.jqb);
            } else {
                if (this.hqb > Double.NEGATIVE_INFINITY) {
                    stringBuffer.append(this.hqb);
                    stringBuffer.append(" <= ");
                }
                stringBuffer.append(this.iqb);
                if (this.jqb < Double.POSITIVE_INFINITY) {
                    stringBuffer.append(" <= ");
                    stringBuffer.append(this.jqb);
                }
            }
            return stringBuffer.toString();
        }
    }

    static final class ld
    extends IlcPPropagator {
        final double ig;
        final nm jg;
        final double kg;

        public ld(double d2, nm nm2, double d3) {
            this.ig = d2;
            this.jg = nm2;
            this.kg = d3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.jg.whenRange(ilcDemon);
        }

        public void post() {
            this.jg.whenRange(this);
        }

        public void propagate() {
            double d2 = this.jg.getDomainLB();
            double d3 = this.jg.getDomainUB();
            if (this.jg.in()) {
                this.jg.getSolver().fail();
            } else if (d3 <= this.kg) {
                if (d2 >= this.ig) {
                    this.jg.getSolver().fail();
                } else {
                    this.jg.setDomainUB(this.ig);
                }
            } else if (d2 >= this.ig) {
                if (d3 <= this.kg) {
                    this.jg.getSolver().fail();
                } else {
                    this.jg.setDomainLB(this.kg);
                }
            }
        }

        public boolean isViolated() {
            double d2 = this.jg.getDomainLB();
            double d3 = this.jg.getDomainUB();
            if (this.jg.in()) {
                return true;
            }
            return this.ig <= d2 && d3 <= this.kg;
        }

        public IlcPPropagator makeOpposite() {
            return new ku(this.ig, this.jg, this.kg);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("opposite(");
            stringBuffer.append(this.ig);
            stringBuffer.append(" <=  ");
            stringBuffer.append(this.jg);
            stringBuffer.append(" <=  ");
            stringBuffer.append(this.kg);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

