/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloFloatLinExprTerm;
import ilog.concert.IloFloatNodeTerm;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloLinearNumExprIterator;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumScalProd;
import ilog.concert.IloNumVar;
import ilog.solver.IlcFloatExpr;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcNumVar;
import ilog.solver.IlcSolver;
import ilog.solver.nm;
import ilog.solver.nu;
import java.util.ArrayList;
import java.util.Iterator;

public class IlcNumScalProd
extends IlcFloatExpr
implements IloNumScalProd {
    protected double _constant = 0.0;
    protected ArrayList _linearpart = new ArrayList();
    protected ArrayList _nodes = new ArrayList();
    private boolean hfc = true;

    public Object extract(IlcSolver ilcSolver) throws IloException {
        Object object;
        Object object2;
        Object object3;
        int n2 = this._linearpart.size() + this._nodes.size();
        if (n2 == 1) {
            LinearTermIterator linearTermIterator = this.linearTermIterator();
            if (linearTermIterator.hasNext()) {
                IloFloatLinExprTerm iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                IlcNumVar ilcNumVar = (IlcNumVar)iloFloatLinExprTerm.getVar();
                nm nm2 = ilcNumVar.getPNumExp(ilcSolver);
                return nm2.multiply(iloFloatLinExprTerm.getCoef()).add(this._constant);
            }
            NodeIterator nodeIterator = this.nodeIterator();
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)nodeIterator.next();
            IlcNumExpr ilcNumExpr = (IlcNumExpr)iloFloatNodeTerm.getExp();
            nm nm3 = ilcNumExpr.getPNumExp(ilcSolver);
            return nm3.multiply(iloFloatNodeTerm.getCoef()).add(this._constant);
        }
        nm[] nmArray = new nm[n2];
        int n3 = 0;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object3 = (IloFloatLinExprTerm)linearTermIterator.next();
            object2 = (IlcNumVar)((IloFloatLinExprTerm)object3).getVar();
            object = ((IlcFloatExpr)object2).getPNumExp(ilcSolver);
            nmArray[n3++] = ((nm)object).multiply(((IloFloatLinExprTerm)object3).getCoef());
        }
        object3 = this.nodeIterator();
        while (((NodeIterator)object3).hasNext()) {
            object2 = (IloFloatNodeTerm)((NodeIterator)object3).next();
            object = (IlcNumExpr)((IloFloatNodeTerm)object2).getExp();
            nm nm4 = ((IlcNumExpr)object).getPNumExp(ilcSolver);
            nmArray[n3++] = nm4.multiply(((IloFloatNodeTerm)object2).getCoef());
        }
        object2 = nm.sum(nmArray);
        object = ((nm)object2).add(this._constant);
        return object;
    }

    public void clear() throws IloException {
        this._constant = 0.0;
        this._linearpart.clear();
        this._nodes.clear();
        this.hfc = true;
    }

    public IlcNumScalProd() {
    }

    public IlcNumScalProd(double d2) {
        this();
        this._constant = d2;
    }

    public void addTo(double d2, IloNumExpr iloNumExpr) {
        IlcNumExpr ilcNumExpr = (IlcNumExpr)iloNumExpr;
        if (ilcNumExpr instanceof IlcNumVar) {
            this._linearpart.add(new IloFloatLinExprTerm(d2, (IlcNumVar)ilcNumExpr));
            this.hfc = false;
        } else if (!ilcNumExpr.shouldHaveDomain() && ilcNumExpr instanceof IlcNumScalProd) {
            Object object;
            IlcNumScalProd ilcNumScalProd = (IlcNumScalProd)ilcNumExpr;
            this._constant += ilcNumScalProd._constant * d2;
            LinearTermIterator linearTermIterator = ilcNumScalProd.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                object = (IloFloatLinExprTerm)linearTermIterator.next();
                this._linearpart.add(new IloFloatLinExprTerm(((IloFloatLinExprTerm)object).getCoef() * d2, (IlcNumVar)((IloFloatLinExprTerm)object).getVar()));
                this.hfc = false;
            }
            if (ilcNumScalProd._nodes.size() != 0) {
                object = ilcNumScalProd.nodeIterator();
                while (((NodeIterator)object).hasNext()) {
                    IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
                    if (d2 == 1.0) {
                        this._nodes.add(iloFloatNodeTerm);
                        continue;
                    }
                    this._nodes.add(new IloFloatNodeTerm(iloFloatNodeTerm.getCoef() * d2, (IlcNumExpr)iloFloatNodeTerm.getExp()));
                }
            }
        } else {
            this._nodes.add(new IloFloatNodeTerm(d2, ilcNumExpr));
        }
    }

    public void addTo(double d2) {
        this._constant += d2;
    }

    public IlcNumScalProd times(double d2) {
        Object object;
        this._constant *= d2;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            ((IloFloatLinExprTerm)object).setCoef(((IloFloatLinExprTerm)object).getCoef() * d2);
        }
        if (this._nodes.size() != 0) {
            object = this.nodeIterator();
            while (((NodeIterator)object).hasNext()) {
                IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
                iloFloatNodeTerm.setCoef(iloFloatNodeTerm.getCoef() * d2);
            }
        }
        return this;
    }

    public void setCoef(IloNumVar iloNumVar, double d2) {
        this.normalize();
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            IloFloatLinExprTerm iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
            if (iloFloatLinExprTerm.getVar() != iloNumVar) continue;
            iloFloatLinExprTerm.setCoef(d2);
            return;
        }
        this.addTo(d2, iloNumVar);
    }

    public LinearTermIterator linearTermIterator() {
        return new LinearTermIterator();
    }

    public NodeIterator nodeIterator() {
        return new NodeIterator();
    }

    public String toString() {
        Object object;
        if (!(this._extracted instanceof nu)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("( ");
        boolean bl2 = true;
        if (this._constant != 0.0) {
            stringBuffer.append(this._constant);
            stringBuffer.append(" ");
            bl2 = false;
        }
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            if (((IloFloatLinExprTerm)object).getCoef() >= 0.0) {
                if (!bl2) {
                    stringBuffer.append("+ ");
                }
                bl2 = false;
                if (((IloFloatLinExprTerm)object).getCoef() != 1.0) {
                    stringBuffer.append(((IloFloatLinExprTerm)object).getCoef());
                    stringBuffer.append("*");
                }
                stringBuffer.append(((IloFloatLinExprTerm)object).getVar().toString());
                stringBuffer.append(" ");
                continue;
            }
            if (!(((IloFloatLinExprTerm)object).getCoef() <= 0.0)) continue;
            if (!bl2) {
                stringBuffer.append("- ");
            }
            bl2 = false;
            if (((IloFloatLinExprTerm)object).getCoef() != -1.0) {
                stringBuffer.append(-((IloFloatLinExprTerm)object).getCoef());
                stringBuffer.append("*");
            }
            stringBuffer.append(((IloFloatLinExprTerm)object).getVar().toString());
            stringBuffer.append(" ");
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
            IlcNumExpr ilcNumExpr = (IlcNumExpr)iloFloatNodeTerm.getExp();
            if (!bl2) {
                stringBuffer.append("+ ");
            }
            bl2 = false;
            if (iloFloatNodeTerm.getCoef() != 1.0) {
                stringBuffer.append(iloFloatNodeTerm.getCoef());
                stringBuffer.append("*");
            }
            stringBuffer.append("( ");
            stringBuffer.append(ilcNumExpr.toString());
            stringBuffer.append(") ");
        }
        if (bl2 && this._constant == 0.0) {
            stringBuffer.append(this._constant);
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    public int getLinearSize() {
        return this._linearpart.size();
    }

    public int getNodesSize() {
        return this._nodes.size();
    }

    public boolean isADifference() throws IloException {
        if (this.getConstant() == 0.0 && this.getLinearSize() + this.getNodesSize() == 2) {
            double d2;
            double d3;
            if (this.getLinearSize() == 2) {
                LinearTermIterator linearTermIterator = this.linearTermIterator();
                IloFloatLinExprTerm iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                d3 = iloFloatLinExprTerm.getCoef();
                iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                d2 = iloFloatLinExprTerm.getCoef();
            } else if (this.getLinearSize() == 1) {
                LinearTermIterator linearTermIterator = this.linearTermIterator();
                IloFloatLinExprTerm iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                d3 = iloFloatLinExprTerm.getCoef();
                NodeIterator nodeIterator = this.nodeIterator();
                IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)nodeIterator.next();
                d2 = iloFloatNodeTerm.getCoef();
            } else {
                NodeIterator nodeIterator = this.nodeIterator();
                IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)nodeIterator.next();
                d3 = iloFloatNodeTerm.getCoef();
                iloFloatNodeTerm = (IloFloatNodeTerm)nodeIterator.next();
                d2 = iloFloatNodeTerm.getCoef();
            }
            return d3 == 1.0 && d2 == -1.0 || d2 == 1.0 && d3 == -1.0;
        }
        return false;
    }

    public IlcNumExpr positiveTermOfDifference() {
        Object object;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            if (((IloFloatLinExprTerm)object).getCoef() != 1.0) continue;
            return (IlcNumVar)((IloFloatLinExprTerm)object).getVar();
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
            if (iloFloatNodeTerm.getCoef() != 1.0) continue;
            return (IlcNumExpr)iloFloatNodeTerm.getExp();
        }
        return null;
    }

    public IlcNumExpr negativeTermOfDifference() {
        Object object;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            if (((IloFloatLinExprTerm)object).getCoef() != -1.0) continue;
            return (IlcNumVar)((IloFloatLinExprTerm)object).getVar();
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
            if (iloFloatNodeTerm.getCoef() != -1.0) continue;
            return (IlcNumExpr)iloFloatNodeTerm.getExp();
        }
        return null;
    }

    public void normalize() {
        if (this._linearpart.size() != 0 && !this.hfc) {
            IlcNumVar ilcNumVar;
            IloFloatLinExprTerm iloFloatLinExprTerm;
            ArrayList<IloFloatLinExprTerm> arrayList = new ArrayList<IloFloatLinExprTerm>();
            LinearTermIterator linearTermIterator = this.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                ilcNumVar = (IlcNumVar)iloFloatLinExprTerm.getVar();
                double d2 = iloFloatLinExprTerm.getCoef();
                if (ilcNumVar.vjb != -1) {
                    IloFloatLinExprTerm iloFloatLinExprTerm2 = (IloFloatLinExprTerm)arrayList.get(ilcNumVar.vjb);
                    iloFloatLinExprTerm2.setCoef(iloFloatLinExprTerm2.getCoef() + d2);
                    continue;
                }
                ilcNumVar.vjb = arrayList.size();
                arrayList.add(new IloFloatLinExprTerm(d2, ilcNumVar));
            }
            this._linearpart = arrayList;
            linearTermIterator = this.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                iloFloatLinExprTerm = (IloFloatLinExprTerm)linearTermIterator.next();
                ilcNumVar = (IlcNumVar)iloFloatLinExprTerm.getVar();
                ilcNumVar.vjb = -1;
            }
        }
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        Object object;
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloNumScalProd iloNumScalProd = iloCPModeler.scalProd(this._constant);
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            iloNumScalProd.addTo(((IloFloatLinExprTerm)object).getCoef(), (IloNumExpr)iloCopyManager.getCopy(((IloFloatLinExprTerm)object).getVar()));
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
            iloNumScalProd.addTo(iloFloatNodeTerm.getCoef(), (IloNumExpr)iloCopyManager.getCopy(iloFloatNodeTerm.getExp()));
        }
        return iloNumScalProd;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        Object object;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloFloatLinExprTerm)linearTermIterator.next();
            ((IloFloatLinExprTerm)object).getVar().needCopy(check);
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloFloatNodeTerm iloFloatNodeTerm = (IloFloatNodeTerm)((NodeIterator)object).next();
            iloFloatNodeTerm.getExp().needCopy(check);
        }
    }

    public void addTerm(double d2, IloNumVar iloNumVar) throws IloException {
        this._linearpart.add(new IloFloatLinExprTerm(d2, iloNumVar));
        this.hfc = false;
    }

    public void addTerm(IloNumVar iloNumVar, double d2) throws IloException {
        this.addTerm(d2, iloNumVar);
    }

    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray, int n2, int n3) throws IloException {
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.addTerm(dArray[n4], iloNumVarArray[n4]);
            ++n4;
        }
    }

    public void addTerms(IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3) throws IloException {
        this.addTerms(dArray, iloNumVarArray, n2, n3);
    }

    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray) throws IloException {
        this.addTerms(dArray, iloNumVarArray, 0, dArray.length);
    }

    public void addTerms(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this.addTerms(dArray, iloNumVarArray);
    }

    public void add(IloLinearNumExpr iloLinearNumExpr) throws IloException {
        IloLinearNumExprIterator iloLinearNumExprIterator = iloLinearNumExpr.linearIterator();
        while (iloLinearNumExprIterator.hasNext()) {
            this.addTerm(iloLinearNumExprIterator.nextNumVar(), iloLinearNumExprIterator.getValue());
        }
    }

    public double getConstant() throws IloException {
        return this._constant;
    }

    public void setConstant(double d2) throws IloException {
        this._constant = d2;
    }

    public void remove(IloNumVar iloNumVar) throws IloException {
        this.setCoef((IlcNumVar)iloNumVar, 0.0);
    }

    public void remove(IloNumVar[] iloNumVarArray, int n2, int n3) throws IloException {
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.remove(iloNumVarArray[n4]);
            ++n4;
        }
    }

    public void remove(IloNumVar[] iloNumVarArray) throws IloException {
        this.remove(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public IloLinearNumExprIterator linearIterator() {
        return new tj();
    }

    class tj
    implements IloLinearNumExprIterator {
        int ev = 0;

        protected tj() {
        }

        public Object getCurrent() {
            return IlcNumScalProd.this._linearpart.get(this.ev);
        }

        public boolean MoveNext() {
            return ++this.ev < IlcNumScalProd.this._linearpart.size();
        }

        public void Reset() {
            this.ev = 0;
        }

        public boolean hasNext() {
            return this.ev < IlcNumScalProd.this._linearpart.size();
        }

        public IloNumVar nextNumVar() {
            return ((IloFloatLinExprTerm)IlcNumScalProd.this._linearpart.get(this.ev++)).getVar();
        }

        public void setNumVar(IloNumVar iloNumVar) {
            ((IloFloatLinExprTerm)IlcNumScalProd.this._linearpart.get(this.ev - 1)).setVar(iloNumVar);
        }

        public Object next() {
            return this.nextNumVar();
        }

        public double getValue() {
            return ((IloFloatLinExprTerm)IlcNumScalProd.this._linearpart.get(this.ev - 1)).getCoef();
        }

        public void setValue(double d2) {
            ((IloFloatLinExprTerm)IlcNumScalProd.this._linearpart.get(this.ev - 1)).setCoef(d2);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public class NodeIterator
    implements Iterator {
        int rjb = 0;

        protected NodeIterator() {
        }

        public boolean hasNext() {
            return this.rjb < IlcNumScalProd.this._nodes.size();
        }

        public Object next() {
            return (IloFloatNodeTerm)IlcNumScalProd.this._nodes.get(this.rjb++);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public class LinearTermIterator
    implements Iterator {
        int tbc = 0;

        protected LinearTermIterator() {
        }

        public boolean hasNext() {
            return this.tbc < IlcNumScalProd.this._linearpart.size();
        }

        public Object next() {
            return (IloFloatLinExprTerm)IlcNumScalProd.this._linearpart.get(this.tbc++);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

