/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class LogicAnalyzer
extends PlotBox {
    public static final boolean DEBUG = false;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final int DONTKNOW = 2;
    public static final int HIGHZ = 3;
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected boolean _painted = false;
    private int _maxdataset = -1;
    private boolean _reusedatasets = false;
    private boolean _firstinset = true;
    private boolean _sawfirstdataset = false;
    private int _radius = 3;
    private int _diameter = 6;
    private boolean _pxgraphBlankLineMode = true;
    private static final int _NATIVE_ENDIAN = 0;
    private static final int _BIG_ENDIAN = 1;
    private static final int _LITTLE_ENDIAN = 2;
    private int _endian = 0;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private static final int _MAX_MARKS = 10;
    private boolean _xyInvalid = false;
    private String _filename = null;
    private boolean _showing = false;
    private double _heightRatio = 0.9;

    private boolean _addLegendIfNecessary(boolean bl) {
        if (!this._sawfirstdataset || this._currentdataset < 0) {
            this._sawfirstdataset = true;
            ++this._currentdataset;
        }
        if (this.getLegend(this._currentdataset) == null) {
            this._firstinset = true;
            this._sawfirstdataset = true;
            this.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstinset) {
            bl = false;
            this._firstinset = false;
        }
        return bl;
    }

    private synchronized void _addPoint(int n, double d, double d2) {
        this._checkDatasetIndex(n);
        if (d < this._xBottom) {
            this._xBottom = d;
        }
        if (d > this._xTop) {
            this._xTop = d;
        }
        if (d2 < this._yBottom) {
            this._yBottom = d2;
        }
        if (d2 > this._yTop) {
            this._yTop = d2;
        }
        PlotPoint plotPoint = new PlotPoint();
        plotPoint.x = d;
        plotPoint.y = d2;
        Vector vector = (Vector)this._points.elementAt(n);
        vector.addElement(plotPoint);
        if (this._showing) {
            this._drawPlotPoint(this.getGraphics(), n, vector.size() - 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void _checkDatasetIndex(int var1_1) {
        if (var1_1 >= 0) ** GOTO lbl6
        throw new IllegalArgumentException("Plot._addPoint: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
lbl6:
            // 2 sources

            ** while (var1_1 >= this._points.size())
        }
lbl7:
        // 1 sources

    }

    protected int _drawLegend(Graphics graphics, int n, int n2) {
        return 0;
    }

    protected void _drawLine(Graphics graphics, int n, long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            if (!(l3 <= (long)this._ulx && l <= (long)this._ulx || l3 >= (long)this._lrx && l >= (long)this._lrx || l4 <= (long)this._uly && l2 <= (long)this._uly || l4 >= (long)this._lry && l2 >= (long)this._lry)) {
                if (l != l3) {
                    if (l3 < (long)this._ulx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._ulx - l3) / (l - l3));
                        l3 = this._ulx;
                    } else if (l3 > (long)this._lrx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._lrx - l3) / (l - l3));
                        l3 = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l4 < (long)this._uly) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._uly - l4) / (l2 - l4));
                        l4 = this._uly;
                    } else if (l4 > (long)this._lry) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._lry - l4) / (l2 - l4));
                        l4 = this._lry;
                    }
                }
                if (l != l3) {
                    if (l < (long)this._ulx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._ulx - l) / (l3 - l));
                        l = this._ulx;
                    } else if (l > (long)this._lrx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._lrx - l) / (l3 - l));
                        l = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l2 < (long)this._uly) {
                        l = (int)(l + (l3 - l) * ((long)this._uly - l2) / (l4 - l2));
                        l2 = this._uly;
                    } else if (l2 > (long)this._lry) {
                        l = (int)(l + (l3 - l) * ((long)this._lry - l2) / (l4 - l2));
                        l2 = this._lry;
                    }
                }
            }
            if (l3 >= (long)this._ulx && l3 <= (long)this._lrx && l4 >= (long)this._uly && l4 <= (long)this._lry && l >= (long)this._ulx && l <= (long)this._lrx && l2 >= (long)this._uly && l2 <= (long)this._lry) {
                graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
            }
        } else {
            graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        this._showing = true;
        int n = 0;
        while (n < this._points.size()) {
            String string = this.getLegend(n);
            if (string == null) {
                string = new String("Data " + n);
            }
            this.addYTick(string, -n);
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                this._drawPlotPoint(graphics, n, n2);
                ++n2;
            }
            ++n;
        }
        this._painted = true;
        this.notifyAll();
    }

    private synchronized void _drawPlotPoint(Graphics graphics, int n, int n2) {
        if (this._usecolor) {
            int n3 = n % PlotBox._colors.length;
            graphics.setColor(PlotBox._colors[n3]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        long l3 = 0L;
        long l4 = 0L;
        if (n2 > 0) {
            PlotPoint plotPoint2 = (PlotPoint)vector.elementAt(n2 - 1);
            l4 = (long)this._lry - (long)((plotPoint2.y - this._yMin) * this._yscale);
            l3 = (long)this._ulx + (long)((plotPoint2.x - this._xMin) * this._xscale);
            this._drawLine(graphics, n, l2, l4, l3, l4, true);
            this._drawLine(graphics, n, l2, l, l2, l4, true);
        }
        this._drawPoint(graphics, n, l2, l, true);
        graphics.setColor(this._foreground);
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (!bl || l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx) {
            int n2 = (int)l;
            int n3 = (int)l2;
        }
    }

    private synchronized void _erasePoint(Graphics graphics, int n, int n2) {
        if (this._usecolor) {
            int n3 = n % PlotBox._colors.length;
            graphics.setColor(PlotBox._colors[n3]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        if (n2 < vector.size() - 1) {
            PlotPoint plotPoint2 = (PlotPoint)vector.elementAt(n2 + 1);
            int n4 = this._ulx + (int)((plotPoint2.x - this._xMin) * this._xscale);
            int n5 = this._lry - (int)((plotPoint2.y - this._yMin) * this._yscale);
            if (plotPoint2.connected) {
                this._drawLine(graphics, n, n4, n5, l2, l, true);
            }
            plotPoint2.connected = false;
        }
        graphics.setColor(this._foreground);
    }

    public synchronized void addPoint(int n, double d, int n2) {
        double d2 = 0.0;
        if (n2 == 1) {
            d2 = (double)(-n) + this._heightRatio * 0.5;
        } else if (n2 == 0) {
            d2 = (double)(-n) - this._heightRatio * 0.5;
        }
        this._addPoint(n, d, d2);
    }

    public synchronized void clear(boolean bl) {
        super.clear(bl);
        this._currentdataset = -1;
        int n = this._points.size();
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._painted = false;
        this._maxdataset = -1;
        this._firstinset = true;
        this._sawfirstdataset = false;
        this._pxgraphBlankLineMode = true;
        this._endian = 0;
        this._xyInvalid = false;
        this._filename = null;
        this._showing = false;
        if (bl) {
            this._reusedatasets = false;
        }
    }

    public synchronized void erasePoint(int n, int n2) {
        PlotPoint plotPoint;
        Vector vector;
        if (this.isShowing()) {
            this._erasePoint(this.getGraphics(), n, n2);
        }
        if ((vector = (Vector)this._points.elementAt(n)) != null && (plotPoint = (PlotPoint)vector.elementAt(n2)) != null) {
            if (plotPoint.x == this._xBottom || plotPoint.x == this._xTop || plotPoint.y == this._yBottom || plotPoint.y == this._yTop) {
                this._xyInvalid = true;
            }
            vector.removeElementAt(n2);
        }
    }

    public synchronized void fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -Double.MIN_VALUE;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -Double.MIN_VALUE;
            int n = 0;
            while (n < this._points.size()) {
                Vector vector = (Vector)this._points.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                    if (plotPoint.x < this._xBottom) {
                        this._xBottom = plotPoint.x;
                    }
                    if (plotPoint.x > this._xTop) {
                        this._xTop = plotPoint.x;
                    }
                    if (plotPoint.y < this._yBottom) {
                        this._yBottom = plotPoint.y;
                    }
                    if (plotPoint.y > this._yTop) {
                        this._yTop = plotPoint.y;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this._xyInvalid = false;
        super.fillPlot();
    }

    public String getCmdLineFilename() {
        return this._filename;
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public void paint(Graphics graphics) {
        this._drawPlot(graphics, true);
    }

    public void parseFile(String string, URL uRL) {
        this._firstinset = true;
        this._sawfirstdataset = false;
        super.parseFile(string, uRL);
    }

    public void read(InputStream inputStream) throws IOException {
        super.read(inputStream);
        this._firstinset = true;
        this._sawfirstdataset = false;
    }

    public void setNumSets(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of data sets (" + n + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this._points.addElement(new Vector());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
            ++n2;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

