package template;

import logist.simulation.Vehicle;
import logist.agent.Agent;
import logist.behavior.DeliberativeBehavior;
import logist.plan.Plan;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;
import logist.topology.Topology.City;

import static algorithms.BFS.bfsPlan;
import static algorithms.AStar.aStarPlan;


public class Deliberative implements DeliberativeBehavior {

	enum Algorithm { BFS, ASTAR}
	Topology topology;
	TaskDistribution td;
	TaskSet carriedTasks;
	
	Agent agent;
	int capacity;

	Algorithm algorithm;
	
	@Override
	public void setup(Topology topology, TaskDistribution td, Agent agent) {
		this.topology = topology;
		this.td = td;
		this.agent = agent;
		
		int capacity = agent.vehicles().get(0).capacity();
		String algorithmName = agent.readProperty("algorithm", String.class, "ASTAR");
		
		algorithm = Algorithm.valueOf(algorithmName.toUpperCase());
	}
	
	@Override
	public Plan plan(Vehicle vehicle, TaskSet tasks) {
		State initialState;
		
		switch (algorithm) {
			case ASTAR:
				initialState = generateInitialState(vehicle, tasks);
				return aStarPlan(vehicle, tasks, initialState);
			case BFS:
				initialState = generateInitialState(vehicle, tasks);
				return bfsPlan(vehicle, tasks, initialState);
			default:
				throw new AssertionError("Should not happen.");
		}
	}

	public State generateInitialState (Vehicle vehicle, TaskSet available) {
		if (carriedTasks == null || this.carriedTasks.isEmpty()) {
			return new State (vehicle, available);
		} else {
			TaskSet stateCarriedTasks = this.carriedTasks.clone();
			this.carriedTasks.clear();
			return new State (vehicle, available, stateCarriedTasks);
		}
	}
	
	@Override
	public void planCancelled(TaskSet carriedTasks) {
		
		if (!carriedTasks.isEmpty()) {
			// This cannot happen for this simple agent, but typically
			// you will need to consider the carriedTasks when the next
			// plan is computed.
			this.carriedTasks = carriedTasks;
		}
	}
}
