package algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;

import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.TaskSet;
import template.State;

public class BFS {
	

	public static Plan bfsPlan(Vehicle vehicle, TaskSet available, State initialState) {
		Queue<State> Q = new LinkedList<State>();
		HashMap<State, Double> history = new HashMap<State, Double>(); // To store the cost for each node. If we come back to the same node, we will check this to see if we found a better path.
		ArrayList<State> finalStates = new ArrayList<State>();
		
		Q.add(initialState);

		while (!Q.isEmpty()) {
			State node = Q.remove(); // Pop the state with the least cost

			// Check whether the state is a final one. In that case we return the plan
			if (node.isFinal())
				finalStates.add(node);
			
			// We add the note and its children if 1) this is the first time it is visited or 2) the cost has decreased
			if (!history.containsKey(node) || (node.getCostToReach() < history.getOrDefault(node, Double.MAX_VALUE))) {
				history.put(node, node.getCostToReach());
				Q.addAll(node.generateChildren());
			}
		}
		
		// Return the optimal state
		State optimalState = Collections.min(finalStates); // we can have reached the final states multiple times. We keep the best path
		return new Plan(vehicle.getCurrentCity(), optimalState.getActionsToReach());		
	}

}
