/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import javax.imageio.ImageIO;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.Painter;
import uchicago.src.sim.util.SimUtilities;

public class LocalPainter
extends Painter {
    protected boolean firstDraw = true;
    protected BufferedImage origImage = null;
    protected int prevX;
    protected int prevY;
    protected int prevWidth;
    protected int prevHeight;
    protected boolean eraseBox = false;

    public LocalPainter() {
    }

    public LocalPainter(DisplaySurface displaySurface, int n, int n2) {
        super(displaySurface, n, n2);
    }

    public void eraseRect(Graphics graphics) {
        if (this.eraseBox) {
            this.createGraphics2D();
            this.g2.setXORMode(this.bgColor);
            this.g2.setColor(this.surface.getForeground());
            this.g2.drawRect(this.prevX, this.prevY, this.prevWidth, this.prevHeight);
            this.g2.dispose();
            graphics.drawImage(this.buffImage, 0, 0, null);
            this.eraseBox = false;
            this.toolkit.sync();
        }
    }

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.buffImage == null) {
            this.createBufferedImage();
        }
        this.createGraphics2D();
        this.g2.setXORMode(this.bgColor);
        this.g2.setColor(this.surface.getForeground());
        if (this.eraseBox) {
            this.g2.drawRect(this.prevX, this.prevY, this.prevWidth, this.prevHeight);
        }
        this.g2.drawRect(n, n2, n3, n4);
        this.prevX = n;
        this.prevY = n2;
        this.prevWidth = n3;
        this.prevHeight = n4;
        this.g2.dispose();
        graphics.drawImage(this.buffImage, 0, 0, null);
        this.eraseBox = true;
        this.toolkit.sync();
    }

    public void paint(Graphics graphics) {
        Object object;
        int n;
        if (this.buffImage == null) {
            this.createBufferedImage();
        }
        this.createGraphics2D();
        this.paintBackground();
        this.simGraphics.setGraphics(this.g2);
        this.simGraphics.setDisplaySurface(this.surface);
        if (this.orderedDisplayables.size() > 0) {
            Collections.sort(this.orderedDisplayables);
            for (n = 0; n < this.orderedDisplayables.size(); ++n) {
                object = (DisplaySurface.DisplayableOrder)this.orderedDisplayables.get(n);
                ((DisplaySurface.DisplayableOrder)object).getDisplayable().drawDisplay(this.simGraphics);
            }
        }
        for (n = 0; n < this.displayables.size(); ++n) {
            object = (Displayable)this.displayables.get(n);
            object.drawDisplay(this.simGraphics);
        }
        this.g2.dispose();
        graphics.drawImage(this.buffImage, 0, 0, null);
        this.eraseBox = false;
        this.toolkit.sync();
    }

    public void takeSnapshot(DataOutputStream dataOutputStream) {
        try {
            ImageIO.write((RenderedImage)this.buffImage, "png", dataOutputStream);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write snapshot image to file", iOException);
        }
    }
}

