/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uchicago.src.sim.engine.gui.ParameterWizard;
import uchicago.src.sim.engine.gui.components.ArrayListListModel;
import uchicago.src.sim.engine.gui.components.DataTypeMismatchException;
import uchicago.src.sim.engine.gui.components.EnhancedJTable;
import uchicago.src.sim.engine.gui.components.ParameterData;
import uchicago.src.sim.engine.gui.components.ParameterDataObjectTableModel;
import uchicago.src.sim.engine.gui.components.RadioBarPanel;
import uchicago.src.sim.engine.gui.model.ConstantParameter;
import uchicago.src.sim.engine.gui.model.DataParameter;
import uchicago.src.sim.engine.gui.model.IncrementParameter;
import uchicago.src.sim.engine.gui.model.ListParameter;
import uchicago.src.sim.engine.gui.model.ParamBlockParameter;

public class ParameterWizardPanel
extends JPanel {
    private static final long serialVersionUID = 4051327855340041520L;
    private static final String treeName = "Parameter Definitions:";
    private DefaultMutableTreeNode top = null;
    private ArrayListListModel inputParmListModel = null;
    private ButtonGroup paramTypeGroup;
    private EnhancedJTable allParameterTable;
    private JButton addNestParamButton = new JButton();
    private JButton removeParamButton = new JButton();
    private JButton addParamButton = new JButton();
    private JButton removeParamBlockButton = new JButton();
    private JButton addParamBlockButton = new JButton();
    private JPanel runEditPanel;
    private JPanel dialogButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel outputLocationPanel;
    private JButton selectButton;
    private JLabel fileNameLabel;
    private JLabel outputLocationLabel;
    private JLabel startLabel = new JLabel();
    private JLabel endLabel = new JLabel();
    private JLabel incrLabel = new JLabel();
    private JTextField startTextField = new JTextField();
    private JTextField endTextField = new JTextField();
    private JTextField incrTextField = new JTextField();
    private JLabel commaLabel;
    private JTextField runsTextField = new JTextField("1");
    private JLabel runsLabel = new JLabel();
    private JList inputParameterList = new JList();
    private JPanel allParametersPanel;
    private JPanel inputParametersPanel;
    private JRadioButton listOfValuesRadioButton = new JRadioButton();
    private JRadioButton incrValueRadioButton = new JRadioButton();
    private JRadioButton constValueRadioButton = new JRadioButton();
    private JPanel paramEditPanel;
    private JTabbedPane tabPane;
    private JTree configuredParamTree = null;
    private ParameterData aParameterData;
    private ParameterDataObjectTableModel aParameterDataObjectTableModel;
    private ParameterWizard aParameterWizard;
    private TreePath curPath;

    public ParameterWizardPanel(ParameterWizard parameterWizard) {
        this.aParameterWizard = parameterWizard;
        this.initComponents();
    }

    public void setInputParameterList(JList jList) {
        this.inputParameterList = jList;
    }

    public JList getInputParameterList() {
        return this.inputParameterList;
    }

    public String getOutputLocation() {
        return this.outputLocationLabel.getText();
    }

    public void setOutputLocation(String string) {
        this.outputLocationLabel.setText(string);
    }

    public void setParameterData(ParameterData parameterData) {
        this.aParameterData = parameterData;
        this.aParameterDataObjectTableModel.setAParameterData(parameterData);
        this.inputParmListModel.setSomeList(parameterData.getInputParameterList());
        ArrayList arrayList = parameterData.getRootNodes();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParamTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(i);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.top, this.top.getChildCount());
        }
        this.expandAll(this.configuredParamTree, true);
        this.setOutputLocation(parameterData.getOutputLocation());
    }

    public void expandAll(JTree jTree, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public void configureOutputFilePanel() {
        this.outputLocationPanel.setLayout(new GridBagLayout());
        this.fileNameLabel = new JLabel();
        this.outputLocationLabel = new JLabel();
        this.selectButton = new JButton();
        this.fileNameLabel.setFont(new Font("Microsoft Sans Serif", 1, 11));
        this.fileNameLabel.setText("File Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        this.outputLocationLabel.setText("File Name Not Specified.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.outputLocationLabel, gridBagConstraints);
        this.selectButton.setText("Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        this.outputLocationPanel.add((Component)this.selectButton, gridBagConstraints);
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.selectButtonAction(false);
            }
        });
    }

    public void rePaintTree() {
        this.configuredParamTree.repaint();
        this.configuredParamTree.invalidate();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParamTree.getModel();
        defaultTreeModel.nodeChanged((TreeNode)this.curPath.getLastPathComponent());
    }

    public void refreshTree() {
        this.top = new DefaultMutableTreeNode(treeName);
        this.configuredParamTree = new JTree(this.top);
        this.configuredParamTree.getSelectionModel().setSelectionMode(1);
        this.configuredParamTree.setRootVisible(false);
        this.configuredParamTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ParameterWizardPanel.this.updateGUIState();
            }
        });
        this.configuredParamTree.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
                try {
                    int n = treeModelEvent.getChildIndices()[0];
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                ParameterWizardPanel.this.updateGUIState();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                ParameterWizardPanel.this.updateGUIState();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    private void updateGUIState() {
        if (this.configuredParamTree.getModel().getChildCount(this.top) == 0) {
            this.changePanelEnableState(this.paramEditPanel, false);
            this.removeParamBlockButton.setEnabled(false);
            this.removeParamButton.setEnabled(false);
        } else {
            if (this.configuredParamTree.getSelectionPath() != null && ((DefaultMutableTreeNode)this.configuredParamTree.getLastSelectedPathComponent()).getUserObject() instanceof ParamBlockParameter) {
                this.addParamBlockButton.setEnabled(false);
            } else {
                this.addParamBlockButton.setEnabled(true);
            }
            this.removeParamBlockButton.setEnabled(true);
            this.changePanelEnableState(this.paramEditPanel, true);
            if (this.inputParameterList.isSelectionEmpty()) {
                this.addNestParamButton.setEnabled(false);
                this.addParamButton.setEnabled(false);
            } else {
                if (this.configuredParamTree.getSelectionPath() != null && this.configuredParamTree.getSelectionPath().getParentPath().getLastPathComponent() != this.top) {
                    this.addParamButton.setEnabled(true);
                } else {
                    this.addParamButton.setEnabled(false);
                }
                this.addNestParamButton.setEnabled(true);
            }
            if (this.configuredParamTree.getSelectionCount() == 0) {
                this.removeParamButton.setEnabled(false);
                this.removeParamBlockButton.setEnabled(false);
            } else {
                this.removeParamButton.setEnabled(true);
                this.removeParamBlockButton.setEnabled(true);
            }
        }
    }

    protected void CancelActionPerformed(ActionEvent actionEvent) {
        this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "EXIT"));
    }

    protected void OKActionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (this.outputLocationLabel.getText() == null || this.outputLocationLabel.getText().equals("")) {
            this.selectButtonAction(true);
            if (this.outputLocationLabel.getText() == null || this.outputLocationLabel.getText().equals("")) {
                JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), "You must select an output parameter file to run in Multi-Run mode.", "Alert", 0);
            }
            bl = this.outputLocationLabel.getText() != null && !this.outputLocationLabel.getText().equals("");
        } else {
            bl = true;
        }
        if (bl) {
            this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "RUN_SIMULATION"));
        }
    }

    protected void addNestParamActionPerformed(ActionEvent actionEvent) {
        DataParameter dataParameter = null;
        try {
            dataParameter = this.createParameterNode();
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), dataTypeMismatchException.getMessage(), "Alert", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParamTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = this.configuredParamTree.getSelectionPath() != null ? (DefaultMutableTreeNode)this.configuredParamTree.getSelectionPath().getLastPathComponent() : this.top;
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.configuredParamTree.scrollPathToVisible(treePath);
        this.configuredParamTree.setSelectionPath(treePath);
    }

    protected void addParmActionPerformed(ActionEvent actionEvent) {
        DataParameter dataParameter = null;
        try {
            dataParameter = this.createParameterNode();
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), dataTypeMismatchException.getMessage(), "Alert", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParamTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = this.configuredParamTree.getSelectionPath() != null ? (DefaultMutableTreeNode)this.configuredParamTree.getSelectionPath().getParentPath().getLastPathComponent() : this.top;
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.configuredParamTree.scrollPathToVisible(treePath);
        this.configuredParamTree.setSelectionPath(treePath);
    }

    protected void addBlockActionPerformed(ActionEvent actionEvent) {
        DataParameter dataParameter = null;
        try {
            dataParameter = this.createBlockNode();
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            JOptionPane.showMessageDialog(this.aParameterWizard.getDialog(), dataTypeMismatchException.getMessage(), "Alert", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dataParameter);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.configuredParamTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = this.configuredParamTree.getSelectionPath() != null ? (DefaultMutableTreeNode)this.configuredParamTree.getSelectionPath().getLastPathComponent() : this.top;
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.configuredParamTree.scrollPathToVisible(treePath);
        this.configuredParamTree.setSelectionPath(treePath);
    }

    protected void inputParameterListChanged(ListSelectionEvent listSelectionEvent) {
        this.updateGUIState();
    }

    protected void removeActionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.configuredParamTree.getSelectionPath() != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.configuredParamTree.getSelectionPath().getLastPathComponent();
        }
        if (!defaultMutableTreeNode.getUserObject().equals(treeName)) {
            ((DefaultTreeModel)this.configuredParamTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    protected void valueTypeSpecificationPerformed(ActionEvent actionEvent) {
        if (this.listOfValuesRadioButton.isSelected()) {
            this.endTextField.setVisible(false);
            this.incrTextField.setVisible(false);
            this.endLabel.setVisible(false);
            this.incrLabel.setVisible(false);
            this.startLabel.setText("List of Values:");
            this.commaLabel.setText("Note: values are space separated");
        } else if (this.constValueRadioButton.isSelected()) {
            this.endTextField.setVisible(false);
            this.incrTextField.setVisible(false);
            this.endLabel.setVisible(false);
            this.incrLabel.setVisible(false);
            this.startLabel.setText("Const Value:");
            this.commaLabel.setText("");
        } else {
            this.endTextField.setVisible(true);
            this.incrTextField.setVisible(true);
            this.endLabel.setVisible(true);
            this.incrLabel.setVisible(true);
            this.startLabel.setText("Start Value:");
            this.commaLabel.setText("");
        }
    }

    private void addParamTypeRadios(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel();
        jLabel.setText(" Parameter Definition: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.incrValueRadioButton.setText("Increment");
        this.incrValueRadioButton.setSelected(true);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.incrValueRadioButton, gridBagConstraints);
        this.listOfValuesRadioButton.setText("List");
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.listOfValuesRadioButton, gridBagConstraints);
        this.constValueRadioButton.setText("Constant");
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.constValueRadioButton, gridBagConstraints);
        this.paramTypeGroup = new ButtonGroup();
        this.incrValueRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.listOfValuesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.constValueRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.valueTypeSpecificationPerformed(actionEvent);
            }
        });
        this.paramTypeGroup.add(this.incrValueRadioButton);
        this.paramTypeGroup.add(this.listOfValuesRadioButton);
        this.paramTypeGroup.add(this.constValueRadioButton);
    }

    private JPanel createParameterEditPanel() {
        this.paramEditPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.addParamTypeRadios(this.paramEditPanel, gridBagConstraints);
        this.startLabel.setText("Start Value:");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.paramEditPanel.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.paramEditPanel.add((Component)this.startTextField, gridBagConstraints);
        this.endLabel.setText("End Value:");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.paramEditPanel.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.paramEditPanel.add((Component)this.endTextField, gridBagConstraints);
        this.incrLabel.setText("Step:");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.paramEditPanel.add((Component)this.incrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.paramEditPanel.add((Component)this.incrTextField, gridBagConstraints);
        this.commaLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 22;
        this.paramEditPanel.add((Component)this.commaLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        this.paramEditPanel.add((Component)new JLabel("Note: you must select a parameter to the left"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.paramEditPanel.add((Component)new JLabel("before you can add"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        this.paramEditPanel.add((Component)this.createParamOperationsPanel(), gridBagConstraints);
        this.paramEditPanel.setBorder(BorderFactory.createTitledBorder("Parameters (disabled until a run is added)"));
        this.changePanelEnableState(this.paramEditPanel, false);
        return this.paramEditPanel;
    }

    private void changePanelEnableState(JPanel jPanel, boolean bl) {
        for (int i = 0; i < jPanel.getComponents().length; ++i) {
            jPanel.getComponent(i).setEnabled(bl);
        }
    }

    private JPanel createRightSidePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.paramEditPanel = this.createParameterEditPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.runEditPanel = this.createRunEditPanel();
        jPanel.add((Component)this.runEditPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.paramEditPanel, gridBagConstraints);
        this.paramEditPanel.setEnabled(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.createCurrentParametersPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel createCurrentParametersPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        JLabel jLabel = new JLabel();
        jLabel.setText("List of parameter definitions:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.configuredParamTree);
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel createRunEditPanel() {
        this.runEditPanel = new JPanel(new GridBagLayout());
        this.runsLabel.setText("Runs:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.runEditPanel.add((Component)this.runsLabel, gridBagConstraints);
        this.runsTextField = new JTextField("1");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.runEditPanel.add((Component)this.runsTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.runEditPanel.add((Component)new JLabel("Note: you can only add a \"run block\" under a parameter"), gridBagConstraints);
        this.addParamBlockButton.setToolTipText("Add a runs block nested under the selected paramter");
        this.addParamBlockButton.setText("Add/Nest");
        this.addParamBlockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.addBlockActionPerformed(actionEvent);
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.runEditPanel.add((Component)this.addParamBlockButton, gridBagConstraints);
        this.removeParamBlockButton.setToolTipText("Remove the selected paramater/run");
        this.removeParamBlockButton.setText("Remove");
        this.removeParamBlockButton.setEnabled(false);
        this.removeParamBlockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.removeActionPerformed(actionEvent);
            }
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        this.runEditPanel.add((Component)this.removeParamBlockButton, gridBagConstraints);
        this.runEditPanel.setBorder(BorderFactory.createTitledBorder("Runs"));
        return this.runEditPanel;
    }

    private JPanel createParamOperationsPanel() {
        JPanel jPanel = new JPanel();
        this.addParamButton.setToolTipText("Add the parameter at the level of the selected parameter/run");
        this.addParamButton.setText("Add");
        this.addParamButton.setEnabled(false);
        jPanel.add((Component)this.addParamButton, "West");
        this.addNestParamButton.setToolTipText("Add the parameter nested under the selected parameter/run");
        this.addNestParamButton.setText("Add Nested");
        this.addNestParamButton.setEnabled(false);
        jPanel.add((Component)this.addNestParamButton, "Center");
        this.removeParamButton.setToolTipText("Remove the selected paramater/run");
        this.removeParamButton.setText("Remove");
        this.removeParamButton.setEnabled(false);
        jPanel.add((Component)this.removeParamButton, "East");
        this.addParamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.addParmActionPerformed(actionEvent);
            }
        });
        this.addNestParamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.addNestParamActionPerformed(actionEvent);
            }
        });
        this.removeParamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.removeActionPerformed(actionEvent);
            }
        });
        return jPanel;
    }

    private void configureInputParametersPanel() {
        this.refreshTree();
        this.inputParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        this.inputParametersPanel.add((Component)this.createAvailableParamsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.fill = 1;
        this.inputParametersPanel.add((Component)this.createRightSidePanel(), gridBagConstraints);
        this.inputParametersPanel.setBorder(BorderFactory.createTitledBorder(" Specify Input Parameters Values "));
    }

    private JPanel createAvailableParamsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Available Parameters"));
        this.inputParmListModel = new ArrayListListModel(new ArrayList());
        this.inputParameterList = new JList(this.inputParmListModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.inputParameterList.setSelectionMode(0);
        this.inputParameterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ParameterWizardPanel.this.inputParameterListChanged(listSelectionEvent);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.inputParameterList);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private Object parseValue(String string, String string2) throws DataTypeMismatchException {
        try {
            if (string2.equalsIgnoreCase("java.lang.Integer")) {
                Integer n = new Integer(string);
                return n;
            }
            if (string2.equalsIgnoreCase("java.lang.Long")) {
                Long l = new Long(string);
                return l;
            }
            if (string2.equalsIgnoreCase("java.lang.String")) {
                return string;
            }
            if (string2.equalsIgnoreCase("java.lang.Float")) {
                Float f = new Float(string);
                return f;
            }
            if (string2.equalsIgnoreCase("java.lang.Byte")) {
                Byte by = new Byte(string);
                return by;
            }
            if (string2.equalsIgnoreCase("java.lang.Double")) {
                Double d = new Double(string);
                return d;
            }
            if (string2.equalsIgnoreCase("java.lang.Boolean")) {
                Boolean bl = new Boolean(string);
                return bl;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataTypeMismatchException(string + " is not of type " + string2);
        }
        return null;
    }

    private DataParameter createParameterNode() throws DataTypeMismatchException {
        String string = null;
        String string2 = null;
        boolean bl = true;
        DataParameter dataParameter = (DataParameter)this.inputParameterList.getSelectedValue();
        String string3 = "";
        try {
            int n;
            if (dataParameter != null) {
                string = dataParameter.getName();
                string2 = dataParameter.getDataType();
            }
            try {
                n = Integer.parseInt(this.runsTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (this.incrValueRadioButton.isSelected()) {
                string3 = "Start";
                Object object = this.parseValue(this.startTextField.getText(), string2);
                string3 = "End";
                Object object2 = this.parseValue(this.endTextField.getText(), string2);
                string3 = "Step";
                Object object3 = this.parseValue(this.incrTextField.getText(), string2);
                IncrementParameter incrementParameter = null;
                incrementParameter = new IncrementParameter(n, string, string2, bl, object, object2, object3);
                return incrementParameter;
            }
            if (this.constValueRadioButton.isSelected()) {
                string3 = "Start";
                Object object = this.parseValue(this.startTextField.getText(), string2);
                ConstantParameter constantParameter = null;
                constantParameter = new ConstantParameter(n, string, string2, bl, object);
                return constantParameter;
            }
            if (this.listOfValuesRadioButton.isSelected()) {
                Object[] objectArray = null;
                string3 = "List value";
                StringTokenizer stringTokenizer = new StringTokenizer(this.startTextField.getText().trim());
                if (stringTokenizer.countTokens() > 0) {
                    objectArray = new Object[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        objectArray[n2] = this.parseValue(stringTokenizer.nextToken(), string2);
                        ++n2;
                    }
                }
                ListParameter listParameter = null;
                listParameter = new ListParameter(n, string, string2, bl, objectArray);
                return listParameter;
            }
            return null;
        }
        catch (DataTypeMismatchException dataTypeMismatchException) {
            throw new DataTypeMismatchException(string3 + " " + dataTypeMismatchException.getMessage(), dataTypeMismatchException);
        }
    }

    private DataParameter createBlockNode() throws DataTypeMismatchException {
        int n;
        try {
            n = Integer.parseInt(this.runsTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return new ParamBlockParameter(n);
    }

    private void initComponents() {
        this.dialogButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tabPane = new JTabbedPane();
        this.inputParametersPanel = new JPanel();
        this.outputLocationPanel = new JPanel();
        this.okButton.setText("OK");
        this.dialogButtonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.dialogButtonPanel.add(this.cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.OKActionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterWizardPanel.this.CancelActionPerformed(actionEvent);
            }
        });
        this.allParametersPanel = new JPanel();
        this.allParametersPanel.setLayout(new GridLayout(1, 1));
        this.aParameterDataObjectTableModel = new ParameterDataObjectTableModel(this.aParameterWizard, this.aParameterData);
        this.allParameterTable = new EnhancedJTable(this.aParameterDataObjectTableModel, 90);
        String[] stringArray = new String[]{"Input", "Output"};
        int[] nArray = new int[]{0, 1};
        this.allParameterTable.setDefaultRenderer(Integer.class, new RadioBarPanel(this.aParameterWizard, stringArray, nArray));
        this.allParameterTable.setDefaultEditor(Integer.class, new RadioBarPanel(this.aParameterWizard, stringArray, nArray));
        this.allParametersPanel.add(new JScrollPane(this.allParameterTable, 20, 30));
        this.allParametersPanel.setBorder(BorderFactory.createTitledBorder(" Specify Parameters Function "));
        this.tabPane.addTab("All Parameters", this.allParametersPanel);
        this.configureInputParametersPanel();
        this.tabPane.addTab("Input Parameters", this.inputParametersPanel);
        this.configureOutputFilePanel();
        this.tabPane.addTab("Parameter File Location", this.outputLocationPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.add((Component)this.dialogButtonPanel, "South");
    }

    private void selectButtonAction(boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle("Choose file to store parameters");
        int n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = this.cleanupFileName(jFileChooser.getSelectedFile().getPath());
            this.outputLocationLabel.setText(string);
            this.aParameterWizard.actionPerformed(new ActionEvent(this.outputLocationLabel, 1001, "CHANGED_OUTPUT_LOCATION"));
        }
    }

    private String cleanupFileName(String string) {
        if (!string.endsWith(".xml")) {
            return string + ".xml";
        }
        return string;
    }

    public DefaultMutableTreeNode getTreeTop() {
        return this.top;
    }

    public static void main(String[] stringArray) {
        ParameterWizardPanel parameterWizardPanel = new ParameterWizardPanel(null);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(parameterWizardPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

