/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcPIntToFloatExpFunctionInterface;
import ilog.solver.be;
import ilog.solver.kh;
import ilog.solver.nm;
import ilog.solver.xh;

class cw
extends be {
    double rub;
    double sub;
    double tub;
    double uub;
    double vub;
    double wub;

    cw(kh kh2, IlcPIntToFloatExpFunctionInterface ilcPIntToFloatExpFunctionInterface) {
        super(kh2, ilcPIntToFloatExpFunctionInterface);
    }

    protected void computeRange() {
        if (this.lw.getDomainPossibleSize() == 0) {
            this.rub = 0.0;
            this.sub = 0.0;
            this.vub = 0.0;
            this.wub = 0.0;
            this.tub = 0.0;
            this.uub = 0.0;
            this.bzb = 0.0;
            this.czb = 0.0;
            return;
        }
        if (this.lw.isBound()) {
            double d2 = 0.0;
            double d3 = 0.0;
            IlcIterator ilcIterator = this.lw.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                nm nm2 = this.fh.getValue(ilcIterator.nextValue());
                if (nm2.isNaN()) {
                    this.setNaN();
                    return;
                }
                d2 = IlcFloat.addDown(d2, nm2.getDomainLB());
                d3 = IlcFloat.addUp(d3, nm2.getDomainUB());
            }
            this.rub = d2;
            this.sub = d3;
            this.vub = d2;
            this.wub = d3;
            this.tub = 0.0;
            this.uub = 0.0;
            this.bzb = d2;
            this.czb = d3;
            return;
        }
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        IlcIterator ilcIterator = this.lw.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n2 = ilcIterator.nextValue();
            nm nm3 = this.fh.getValue(n2);
            double d10 = nm3.getDomainLB();
            double d11 = nm3.getDomainUB();
            if (this.lw.isDomainRequired(n2)) {
                if (nm3.isNaN()) {
                    this.setNaN();
                    return;
                }
                d6 = IlcFloat.addDown(d6, d10);
                d7 = IlcFloat.addUp(d7, d11);
                continue;
            }
            if (nm3.isNaN()) continue;
            if (d10 < 0.0) {
                d8 = IlcFloat.addDown(d8, d10);
            }
            if (d11 > 0.0) {
                d9 = IlcFloat.addUp(d9, d11);
            }
            if (d10 < d4) {
                d4 = d10;
            }
            if (!(d11 > d5)) continue;
            d5 = d11;
        }
        this.rub = d6;
        this.sub = d7;
        this.vub = d6 + d8;
        this.wub = d7 + d9;
        this.tub = d4;
        this.uub = d5;
        IlcPIntAbstractVar ilcPIntAbstractVar = this.lw.getCardinality();
        int n3 = this.lw.getDomainRequiredSize();
        int n4 = Math.max(0, ilcPIntAbstractVar.getDomainMin() - n3);
        int n5 = ilcPIntAbstractVar.getDomainMax() - n3;
        d4 = d4 < 0.0 ? IlcFloat.addDown(IlcFloat.roundDown(d4 * (double)n5), d6) : IlcFloat.addDown(IlcFloat.roundDown(d4 * (double)n4), d6);
        d5 = d5 < 0.0 ? IlcFloat.addUp(IlcFloat.roundUp(d5 * (double)n4), d7) : IlcFloat.addUp(IlcFloat.roundUp(d5 * (double)n5), d7);
        this.bzb = Math.max(this.vub, d4);
        this.czb = Math.min(this.wub, d5);
    }

    protected void setRangeInternal(double d2, double d3) {
        int n2;
        double d4;
        double d5;
        nm nm2;
        int n3;
        IlcIterator ilcIterator;
        xh xh2 = this.lw.getDomainRequiredSet();
        xh xh3 = this.lw.getDomainPossibleSet();
        double d6 = this.bzb;
        double d7 = this.czb;
        double d8 = this.tub;
        double d9 = this.uub;
        double d10 = this.rub;
        double d11 = this.sub;
        double d12 = IlcFloat.addDown(d3, -this.vub);
        double d13 = IlcFloat.addUp(d3, -this.vub);
        if (d13 < 0.0) {
            this.fail();
        }
        if (d3 < d7) {
            double d14;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n3 = ilcIterator.nextValue();
                nm2 = this.fh.getValue(n3);
                if (nm2.isNaN()) {
                    if (xh2.isInSet(n3)) {
                        this.fail();
                    } else {
                        this.lw.removeDomainPossible(n3);
                        continue;
                    }
                }
                d5 = nm2.getDomainLB();
                d4 = nm2.getDomainUB();
                if (xh2.isInSet(n3)) {
                    nm2.setDomainUB(IlcFloat.addUp(d5, d13));
                    continue;
                }
                if (d5 > d13) {
                    this.lw.removeDomainPossible(n3);
                    continue;
                }
                if (!(-d5 > d13)) continue;
                this.lw.addDomainRequired(n3);
                nm2.setDomainUB(IlcFloat.addUp(d5, d13));
                d10 = IlcFloat.addDown(d10, d5);
                d11 = IlcFloat.addUp(d11, d4);
            }
            n3 = xh2.getCardinal();
            if (d8 < 0.0) {
                double d15;
                if (d8 != Double.NEGATIVE_INFINITY && d10 > d3 && (d15 = Math.ceil(IlcFloat.roundDown(IlcFloat.addDown(d10, -d3) / -d8))) > -2.147483647E9 && d15 < 2.147483647E9 && (n2 = (int)d15) > 0) {
                    this.lw.getCardinality().setDomainMin(n3 + n2);
                }
            } else if (d8 > 0.0 && (d14 = Math.floor(IlcFloat.roundUp(IlcFloat.addUp(d3, -d10) / d8))) > -2.147483647E9 && d14 < 2.147483647E9 && (n2 = (int)d14) >= 0) {
                this.lw.getCardinality().setDomainMax(n3 + n2);
            }
        }
        d12 = IlcFloat.addDown(this.wub, -d2);
        d13 = IlcFloat.addUp(this.wub, -d2);
        if (d13 < 0.0) {
            this.fail();
        }
        if (d2 > d6) {
            double d16;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n3 = ilcIterator.nextValue();
                nm2 = this.fh.getValue(n3);
                if (nm2.isNaN()) {
                    if (xh2.isInSet(n3)) {
                        this.fail();
                    } else {
                        this.lw.removeDomainPossible(n3);
                        continue;
                    }
                }
                d5 = nm2.getDomainLB();
                d4 = nm2.getDomainUB();
                if (xh2.isInSet(n3)) {
                    nm2.setDomainLB(IlcFloat.addDown(d4, -d13));
                    continue;
                }
                if (d5 > d13) {
                    this.lw.addDomainRequired(n3);
                    nm2.setDomainLB(IlcFloat.addDown(d4, -d13));
                    d10 = IlcFloat.addDown(d10, d5);
                    d11 = IlcFloat.addUp(d11, d4);
                    continue;
                }
                if (!(-d5 > d13)) continue;
                this.lw.removeDomainPossible(n3);
            }
            n3 = xh2.getCardinal();
            if (d9 < 0.0) {
                double d17;
                if (d11 > d2 && (d17 = Math.floor(IlcFloat.roundUp(IlcFloat.addUp(d11, -d2) / -d8))) > 0.0 && d17 < 2.147483647E9) {
                    n2 = (int)d17;
                    this.lw.getCardinality().setDomainMax(n3 + n2);
                }
            } else if (d9 > 0.0 && d9 != Double.POSITIVE_INFINITY && d2 > d11 && (d16 = Math.ceil(IlcFloat.roundDown(IlcFloat.addDown(d2, -d11) / d9))) > 0.0 && d16 < 2.147483647E9) {
                n2 = (int)d16;
                this.lw.getCardinality().setDomainMin(n3 + n2);
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcPSum(Set, FloatExp F(x)):[");
        stringBuffer.append(this.getDomainLB());
        stringBuffer.append("..");
        stringBuffer.append(this.getDomainUB());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

