/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloFloatDomain;
import ilog.concert.IloModeler;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloStorable;
import ilog.concert.model.IlcFloatDomain;
import ilog.solver.IlcFloatExpr;
import ilog.solver.IlcGoal;
import ilog.solver.IlcInstantiable;
import ilog.solver.IlcSolver;
import ilog.solver.gab;
import ilog.solver.no;
import ilog.solver.nu;

public final class IlcNumVar
extends IlcFloatExpr
implements IloNumVar,
IlcInstantiable,
IloStorable {
    private IloNumVarType ujb = IloNumVarType.Float;
    protected String _name = null;
    protected IloFloatDomain _domain = null;
    int vjb = -1;

    public IloNumVarType getType() throws IloException {
        return this.ujb;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public IlcNumVar(IloFloatDomain iloFloatDomain, String string) {
        this._name = string;
        this._domain = iloFloatDomain;
    }

    public IlcNumVar(IloFloatDomain iloFloatDomain, IloNumVarType iloNumVarType, String string) {
        this.ujb = iloNumVarType;
        this._name = string;
        this._domain = iloFloatDomain;
    }

    public IlcNumVar(IloFloatDomain iloFloatDomain) {
        this(iloFloatDomain, IloNumVarType.Float, null);
    }

    public IlcNumVar(IloFloatDomain iloFloatDomain, IloNumVarType iloNumVarType) {
        this(iloFloatDomain, iloNumVarType, null);
    }

    public IlcNumVar(double d2, double d3, String string) throws IloException {
        this._name = string;
        this._domain = new IlcFloatDomain(d2, d3);
    }

    public IlcNumVar(double d2, double d3, IloNumVarType iloNumVarType, String string) throws IloException {
        this.ujb = iloNumVarType;
        this._name = string;
        this._domain = new IlcFloatDomain(d2, d3);
    }

    public IlcNumVar(double d2, double d3) throws IloException {
        this(d2, d3, IloNumVarType.Float, null);
    }

    public IlcNumVar(double d2, double d3, IloNumVarType iloNumVarType) throws IloException {
        this(d2, d3, iloNumVarType, null);
    }

    public double getLB() {
        return this._domain.getLB();
    }

    public double getUB() {
        return this._domain.getUB();
    }

    public void setLB(double d2) throws IloException {
        this._domain.setLB(d2);
    }

    public void setUB(double d2) throws IloException {
        this._domain.setUB(d2);
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ilcSolver.addVar(this);
        gab gab2 = new gab(ilcSolver, this._domain.getLB(), this._domain.getUB(), this.ujb);
        if (this.sf) {
            gab2.setPrecision(this.pf, this.qf, this.rf);
        }
        gab2.pdc = this._name;
        return gab2;
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof nu)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name != null) {
            stringBuffer.append(this._name);
        }
        stringBuffer.append(this._domain);
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        return iloModeler.numVar(this._domain.getLB(), this._domain.getUB(), this.ujb, this._name);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
        this._domain.needCopy(check);
    }

    public IlcGoal initDefaultGoal(IlcSolver ilcSolver) {
        return new no(this);
    }
}

