/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloAnyDomain;
import ilog.concert.IloAnyVar;
import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntEncoder;
import ilog.concert.IloStorable;
import ilog.concert.model.IlcAnyDomain;
import ilog.solver.IlcAnyExpr;
import ilog.solver.IlcGoal;
import ilog.solver.IlcInstantiable;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcSolver;
import ilog.solver.oab;
import java.util.Iterator;

public final class IlcAnyVar
extends IlcAnyExpr
implements IloAnyVar,
IlcInstantiable,
IloStorable {
    protected String _name = null;
    protected IloAnyDomain _domain;

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    IlcAnyVar(IloAnyDomain iloAnyDomain, String string) throws IloException {
        this._domain = iloAnyDomain;
        this._name = string;
    }

    IlcAnyVar(IloAnyDomain iloAnyDomain) throws IloException {
        this(iloAnyDomain, null);
    }

    IlcAnyVar(Object[] objectArray, String string) throws IloException {
        this(new IlcAnyDomain(objectArray), string);
    }

    IlcAnyVar(Object[] objectArray) throws IloException {
        this(objectArray, null);
    }

    public Object[] getValues() {
        return this._domain.getValues();
    }

    public void setValues(Object[] objectArray) throws IloException {
        this._domain.setValues(objectArray);
    }

    public void setValue(Object object) throws IloException {
        this._domain.setValue(object);
    }

    public void removeValue(Object object) throws IloException {
        this._domain.removeValue(object);
    }

    protected int[] getIntValues(IloIntEncoder iloIntEncoder) throws IloException {
        Object[] objectArray = this._domain.getValues();
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            nArray[n2] = iloIntEncoder.objectToInt(objectArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ilcSolver.addVar(this);
        return IlcPIntAbstractVar.intVar(ilcSolver, this.getIntValues(ilcSolver.getIntEncoder()), this._name);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name != null) {
            stringBuffer.append(this._name);
        }
        if (!(this._extracted instanceof oab)) {
            stringBuffer.append("[");
            if (this.isBound()) {
                stringBuffer.append(this.getDomainValue());
            } else {
                Iterator iterator = this.domainIterator();
                stringBuffer.append(iterator.next().toString());
                while (iterator.hasNext()) {
                    stringBuffer.append(" ");
                    stringBuffer.append(iterator.next().toString());
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        stringBuffer.append(this._domain);
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        return iloCPModeler.anyVar(this._domain.getValues(), this._name);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
        this._domain.needCopy(check);
    }

    public IlcGoal initDefaultGoal(IlcSolver ilcSolver) {
        return ilcSolver.generate(this);
    }
}

