/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.wq;

class yj
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;

    yj(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        kh kh2 = (kh)this._var1.getExtracted(ilcSolver);
        kh kh3 = (kh)this._var2.getExtracted(ilcSolver);
        return new uo(kh2, kh3);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("intersect(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.intersect((IloIntSetVar)iloCopyManager.getCopy(this._var1), (IloIntSetVar)iloCopyManager.getCopy(this._var2));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
    }

    static final class uo
    extends IlcPPropagator {
        final kh bgb;
        final kh cgb;

        public uo(kh kh2, kh kh3) {
            this.bgb = kh2;
            this.cgb = kh3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.bgb.whenDomain(ilcDemon);
            this.cgb.whenDomain(ilcDemon);
        }

        public void post() {
            this.bgb.getCardinality().setDomainMin(1);
            this.cgb.getCardinality().setDomainMin(1);
            this.bgb.whenDomain(this);
            this.cgb.whenDomain(this);
        }

        public void propagate() {
            kh kh2 = this.bgb;
            kh kh3 = this.cgb;
            if (kh2.getDomainPossibleSize() > kh3.getDomainPossibleSize()) {
                kh2 = kh3;
                kh3 = this.bgb;
            }
            IlcIterator ilcIterator = kh2.getDomainPossibleIterator();
            boolean bl2 = false;
            int n2 = 0;
            while (ilcIterator.hasNext()) {
                int n3 = ilcIterator.nextValue();
                if (!kh3.isDomainPossible(n3)) continue;
                if (bl2) {
                    return;
                }
                n2 = n3;
                bl2 = true;
            }
            if (!bl2) {
                kh2.getSolver().fail();
            }
            kh2.addDomainRequired(n2);
            kh3.addDomainRequired(n2);
        }

        public boolean isViolated() {
            kh kh2 = this.bgb;
            kh kh3 = this.cgb;
            if (kh2.getDomainPossibleSize() > kh3.getDomainPossibleSize()) {
                kh2 = kh3;
                kh3 = this.bgb;
            }
            IlcIterator ilcIterator = kh2.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                if (!kh3.isDomainPossible(ilcIterator.nextValue())) continue;
                return false;
            }
            return true;
        }

        public IlcPPropagator makeOpposite() {
            return new wq.rn(this.bgb, this.cgb);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.bgb);
            stringBuffer.append(" overlaps ");
            stringBuffer.append(this.cgb);
            return stringBuffer.toString();
        }
    }
}

