/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.hg;
import ilog.solver.uq;
import ilog.solver.ys;

final class nt
extends uq {
    final ys[] iob;
    private long job;
    private long kob;
    private long lob;
    private final int mob;
    private final int nob;

    public nt(ys[] ysArray, int n2, int n3) throws IlcSolverRuntimeError {
        this.iob = ysArray;
        this.mob = n2;
        this.nob = n3;
        int n4 = ysArray.length;
        if (n4 == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        if (n4 == Integer.MAX_VALUE) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        int n5 = n2;
        while (n5 < n3) {
            ysArray[n5].isUsed(this);
            ++n5;
        }
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        int n2 = 0x3FFFFFFF / (this.nob - this.mob);
        int n3 = -n2;
        int n4 = this.mob;
        while (n4 < this.nob) {
            if (this.iob[n4].gr() || this.iob[n4].getDomainMin() < n3 || this.iob[n4].getDomainMax() > n2) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    protected final hg[] getVars() {
        if (this.mob == 0 && this.nob == this.iob.length) {
            return this.iob;
        }
        hg[] hgArray = new ys[this.nob - this.mob];
        System.arraycopy(this.iob, this.mob, hgArray, 0, this.nob - this.mob);
        return hgArray;
    }

    public IlcSolver getSolver() {
        return this.iob[this.mob].getSolver();
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected void computeRange() {
        this.getSolver();
        if (this.gr()) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n2 = this.mob;
            while (n2 < this.nob) {
                long l5 = this.iob[n2].getDomainMin();
                long l6 = this.iob[n2].getDomainMax();
                l2 += l5;
                l3 += l6;
                long l7 = l6 - l5;
                if (l4 < l7) {
                    l4 = l7;
                }
                ++n2;
            }
            this.kob = l2;
            this.lob = l3;
            this.safeSetBoundsLong(l2, l3);
            this.job = l4;
        } else {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.mob;
            while (n6 < this.nob) {
                int n7 = this.iob[n6].getDomainMin();
                int n8 = this.iob[n6].getDomainMax();
                n3 += n7;
                n4 += n8;
                int n9 = n8 - n7;
                if (n5 < n9) {
                    n5 = n9;
                }
                ++n6;
            }
            this.ljb = n3;
            this.mjb = n4;
            this.job = n5;
        }
    }

    protected void setRangeInternal(int n2, int n3) {
        block4: {
            block3: {
                this.fq();
                this.getSolver();
                if (!this.gr()) break block3;
                long l2 = (long)n2 - this.lob;
                long l3 = (long)n3 - this.kob;
                if (this.job <= -l2 && this.job <= l3) break block4;
                int n4 = this.mob;
                while (n4 < this.nob) {
                    ys ys2 = this.iob[n4];
                    ys2.setDomainRangeLong(l2 + (long)ys2.getDomainMax(), l3 + (long)ys2.getDomainMin());
                    ++n4;
                }
                break block4;
            }
            int n5 = n2 - this.mjb;
            int n6 = n3 - this.ljb;
            if (this.job > (long)(-n5) || this.job > (long)n6) {
                int n7 = this.mob;
                while (n7 < this.nob) {
                    ys ys3 = this.iob[n7];
                    ys3.setDomainRange(n5 + ys3.getDomainMax(), n6 + ys3.getDomainMin());
                    ++n7;
                }
            }
        }
    }

    protected void removeValueInternal(int n2) {
    }

    protected void removeIntervalInternal(int n2, int n3) {
    }

    public synchronized String toString() {
        if (this.ojb != null) {
            return this.ojb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sum([");
        int n2 = this.mob;
        while (n2 < this.nob - 1) {
            stringBuffer.append(this.iob[n2]);
            stringBuffer.append(", ");
            ++n2;
        }
        stringBuffer.append(this.iob[this.nob - 1]);
        stringBuffer.append("])");
        return stringBuffer.toString();
    }
}

