/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloIntToNumFunction;
import ilog.concert.IloNumExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIterator;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.nm;
import ilog.solver.ys;

class fe
extends IlcConstraint {
    protected final IlcNumExpr _var;
    protected final IloIntToNumFunction _func;
    protected final IlcIntExpr _index;

    public fe(IloNumExpr iloNumExpr, IloIntToNumFunction iloIntToNumFunction, IloIntExpr iloIntExpr) {
        this._var = (IlcNumExpr)iloNumExpr;
        this._func = iloIntToNumFunction;
        this._index = (IlcIntExpr)iloIntExpr;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._var.getPNumExp(ilcSolver);
        ys ys2 = this._index.getPIntExp(ilcSolver);
        return new bw(nm2, this._func, ys2);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("element(");
        stringBuffer.append(this._var);
        stringBuffer.append(", ");
        stringBuffer.append(this._index);
        stringBuffer.append(", ");
        stringBuffer.append(this._func);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.element((IloNumExpr)iloCopyManager.getCopy(this._var), (IloIntExpr)iloCopyManager.getCopy(this._index), this._func);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var.needCopy(check);
        this._index.needCopy(check);
    }

    static final class bw
    extends IlcPPropagator {
        final nm oub;
        final IloIntToNumFunction pub;
        final ys qub;

        public bw(nm nm2, IloIntToNumFunction iloIntToNumFunction, ys ys2) {
            this.oub = nm2;
            nm2.kn();
            this.pub = iloIntToNumFunction;
            this.qub = ys2;
            ys2.kn();
        }

        public void post() {
            this.oub.whenRange(new ep());
            this.qub.whenDomain(new lp());
        }

        public void propagate() {
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            IlcIterator ilcIterator = this.qub.domainIterator();
            while (ilcIterator.hasNext()) {
                double d4 = this.pub.getValue(ilcIterator.nextValue());
                if (d4 < d2) {
                    d2 = d4;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
            this.oub.setDomainRange(d2, d3);
            this.jv();
            this.mv();
        }

        private void jv() {
            double d2 = this.oub.getDomainUB();
            double d3 = this.oub.getDomainLB();
            IlcIterator ilcIterator = this.qub.domainIterator();
            while (ilcIterator.hasNext()) {
                double d4 = this.pub.getValue(ilcIterator.nextValue());
                if (d4 > d3) {
                    d3 = d4;
                }
                if (!(d4 < d2)) continue;
                d2 = d4;
            }
            this.oub.setDomainRange(d2, d3);
        }

        private void mv() {
            IlcIterator ilcIterator = this.qub.domainIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                if (this.oub.isInDomain(this.pub.getValue(n2))) continue;
                this.qub.removeDomainValue(n2);
            }
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("element(");
            stringBuffer.append(this.oub);
            stringBuffer.append(", ");
            stringBuffer.append(this.qub);
            stringBuffer.append(", ");
            stringBuffer.append(this.pub);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        class lp
        extends IlcDemon {
            lp() {
            }

            public void propagate() {
                bw.this.jv();
            }
        }

        class ep
        extends IlcDemon {
            ep() {
            }

            public void propagate() {
                bw.this.mv();
            }
        }
    }
}

