/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.function.IntDoubleProcedure;
import cern.colt.map.OpenIntDoubleHashMap;
import java.util.List;
import uchicago.src.collection.RangeMap;
import uchicago.src.sim.network.AbstractProbabilityRule;

public class UniformReinforcement
extends AbstractProbabilityRule {
    private float discount = 1.0f;
    private float amtToUpdate = 1.0f;
    private OpenIntDoubleHashMap curWeights = new OpenIntDoubleHashMap();

    public UniformReinforcement(List list, float f) {
        this(list, f, 1.0f);
    }

    public UniformReinforcement(List list, float f, float f2) {
        super(list, f);
        this.amtToUpdate = f2;
    }

    public UniformReinforcement(List list, float f, Object object) {
        this(list, f, object, 1.0f);
    }

    public UniformReinforcement(List list, float f, Object object, float f2) {
        super(list, f, object);
        this.amtToUpdate = f2;
    }

    public void setPastDiscount(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Discount must be between 0 and 1");
        }
        this.discount = f;
    }

    public RangeMap makeProbabilityMap(RangeMap rangeMap) {
        if (this.discount != 1.0f) {
            for (int i = 0; i < this.weights.size(); ++i) {
                float f = this.weights.getQuick(i) * this.discount;
                this.weights.setQuick(i, f);
            }
            this.curWeights.forEachPair(new IntDoubleProcedure(){

                public boolean apply(int n, double d) {
                    float f = UniformReinforcement.this.weights.getQuick(n);
                    UniformReinforcement.this.weights.setQuick(n, (float)((double)f + d));
                    return true;
                }
            });
            this.curWeights.clear();
        }
        return super.makeProbabilityMap(rangeMap);
    }

    public double getProbability(Object object) {
        return (double)this.getWeight(object) / this.sum;
    }

    public void update(Object object) {
        this.update(object, this.amtToUpdate);
    }

    public void update(Object object, float f) {
        if (this.discount == 1.0f) {
            this.addToNodeWeight(object, f);
        } else {
            int n = (Integer)this.weightMap.get(object);
            this.curWeights.put(n, (double)f);
        }
    }
}

