/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;
import template.Candidate;
import template.PD_Action;

public class AuctionTemplate
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private Random random;
    private Vehicle vehicle;
    private Topology.City currentCity;
    private double timeout_plan;
    private List<List<Double>> all_bids;
    private List<Candidate> other_plans;
    private Candidate current_best_plan;
    private Candidate if_win_best_plan;
    private List<Vehicle> vehicles;
    private double profit_ratio;
    private List<Double> other_costs;
    private double money_won;
    private double current_bid;
    List<Task> ordering;
    List<Topology.City> agentHomeCities;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.vehicle = (Vehicle)agent.vehicles().get(0);
        this.vehicles = agent.vehicles();
        this.currentCity = this.vehicle.homeCity();
        this.other_plans = new ArrayList<Candidate>();
        this.all_bids = new ArrayList<List<Double>>();
        long seed = -9019554669489983951L * (long)this.currentCity.hashCode() * (long)agent.id();
        this.random = new Random(seed);
        this.timeout_plan = 10000.0;
        this.current_best_plan = Candidate.SelectInitialSolution(this.random, this.vehicles, new ArrayList<Task>());
        this.profit_ratio = 1.01;
        this.other_costs = new ArrayList<Double>();
        ArrayList ordering = new ArrayList();
        System.out.println(this.current_best_plan.cost + " test ");
        this.ordering = new ArrayList<Task>();
        this.money_won = 0.0;
        this.current_bid = -1.0;
        this.agentHomeCities = agent.vehicles().stream().map(Vehicle::homeCity).collect(Collectors.toList());
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        if (winner == this.agent.id()) {
            this.current_best_plan = this.if_win_best_plan;
            System.out.println(this.money_won + " moneywoonb ");
            this.money_won += this.current_bid;
            System.out.println(this.money_won + " moneywoon ");
            this.ordering.add(previous);
            this.profit_ratio += 0.2;
        } else if (this.profit_ratio > 1.1) {
            this.profit_ratio -= 0.1;
        }
        if (this.other_plans.isEmpty()) {
            for (Long bid : bids) {
                this.other_plans.add(Candidate.SelectInitialSolution(this.random, this.vehicles, new ArrayList<Task>()));
            }
        }
        double winner_ratio = bids[winner].longValue();
        this.other_plans.set(winner, this.marginal_optimal(previous, this.other_plans.get(winner)));
    }

    public Long askPrice(Task task) {
        TaskSet Tasks = this.agent.getTasks();
        this.if_win_best_plan = this.marginal_optimal(task, this.current_best_plan);
        double marginal_cost = this.if_win_best_plan.cost - this.current_best_plan.cost;
        double adjustedBid = this.bid_value(marginal_cost, task);
        adjustedBid = this.profit_ratio * this.bid_value(marginal_cost, task);
        System.out.println(" StrongBid " + adjustedBid);
        this.current_bid = adjustedBid = (double)this.refineBid(task, (long)marginal_cost, (long)adjustedBid).longValue();
        return (long)adjustedBid;
    }

    public double bid_value(double marginal_cost, Task task) {
        double min_bid = Double.MAX_VALUE;
        int i = 0;
        if (this.other_plans.isEmpty()) {
            min_bid = -1.0;
        }
        for (Candidate candidate : this.other_plans) {
            if (i != this.agent.id()) {
                this.other_costs.add(candidate.cost);
                double candidate_cost = this.marginal_optimal((Task)task, (Candidate)candidate).cost - candidate.cost;
                if (candidate_cost < min_bid) {
                    min_bid = candidate_cost;
                }
            }
            ++i;
        }
        System.out.println(min_bid + " f " + marginal_cost);
        if (min_bid < marginal_cost) {
            return marginal_cost;
        }
        if (min_bid == marginal_cost) {
            return min_bid;
        }
        return min_bid - 1.0;
    }

    public Candidate marginal_optimal(Task task, Candidate candidate) {
        double bestCost = Double.MAX_VALUE;
        Candidate bestCandidate = candidate.clone();
        for (int v = 0; v < candidate.vehicles.size(); ++v) {
            Vehicle vehicle = candidate.vehicles.get(v);
            List<PD_Action> actions = candidate.plans.get(v);
            for (int i = 0; i < actions.size() + 1; ++i) {
                for (int j = i + 1; j < actions.size() + 2; ++j) {
                    Candidate new_cand = candidate.clone();
                    PD_Action action_pick = new PD_Action(true, task);
                    PD_Action action_deliv = new PD_Action(false, task);
                    double old_cost = Candidate.ComputeCost(vehicle, new_cand.plans.get(v));
                    new_cand.plans.get(v).add(i, action_pick);
                    new_cand.plans.get(v).add(j, action_deliv);
                    new_cand.taskLists.get(v).add(task);
                    double new_added_cost = Candidate.ComputeCost(vehicle, new_cand.plans.get(v));
                    double n_cost = new_added_cost - old_cost;
                    Candidate final_new_cand = new Candidate(new_cand.vehicles, new_cand.plans, new_cand.taskLists, new_cand.cost + n_cost);
                    boolean satis = Candidate.SatisfiesWeightConstraints(new_cand.plans.get(v), vehicle.capacity());
                    if (!satis || !(n_cost < bestCost)) continue;
                    bestCost = n_cost;
                    bestCandidate = final_new_cand;
                }
            }
        }
        return bestCandidate;
    }

    public Candidate recompute_dynamic(TaskSet tasks) {
        Candidate new_candidate = Candidate.SelectInitialSolution(this.random, this.vehicles, new ArrayList<Task>());
        for (Task task : this.ordering) {
            for (Task task_to_put : tasks) {
                if (task_to_put.id != task.id) continue;
                new_candidate = this.marginal_optimal(task_to_put, new_candidate);
            }
        }
        return new_candidate;
    }

    public Long refineBid(Task task, Long marginalCost, Long myBid) {
        if (!myBid.equals(marginalCost)) {
            return myBid;
        }
        double speculatedProbability = 0.0;
        for (Task wonTask : this.ordering) {
            double probDeliveryPickup = this.distribution.probability(wonTask.deliveryCity, task.pickupCity);
            double probPickupDelivery = this.distribution.probability(task.deliveryCity, wonTask.pickupCity);
            double probHomeCity = 0.0;
            for (Topology.City homeCity : this.agentHomeCities) {
                probHomeCity = Math.max(this.distribution.probability(homeCity, wonTask.pickupCity), probHomeCity);
            }
            speculatedProbability = Math.max(Math.max(probDeliveryPickup, probPickupDelivery), Math.max(probHomeCity, speculatedProbability));
        }
        System.out.println("Speculated probability: " + speculatedProbability);
        if (speculatedProbability > 0.2) {
            System.out.println("Decided to bid lower!");
            myBid = 0.75 * (double)myBid.longValue() > (double)marginalCost.longValue() ? Long.valueOf((long)(0.75 * (double)myBid.longValue())) : Long.valueOf(marginalCost);
        }
        return myBid;
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        for (Task task : tasks) {
            System.out.println(task);
        }
        System.out.println(" Next ");
        for (Task task : this.ordering) {
            System.out.println(task);
        }
        Candidate final_best_plan = this.recompute_dynamic(tasks);
        List<Plan> plan = this.PlanFromSolution(final_best_plan);
        System.out.println("M9 MoneyString : " + this.profit_ratio + " " + this.money_won + " Nb-tasks " + tasks.size() + " curr_best " + final_best_plan.cost);
        return plan;
    }

    public boolean check_if_same(Task t1, Task t2) {
        return t1.pickupCity == t2.pickupCity && t1.deliveryCity == t2.deliveryCity && t1.weight == t2.weight;
    }

    public Candidate LocalChoice(List<Candidate> N, Candidate A) {
        if (this.random.nextFloat() < 0.0f) {
            return A;
        }
        int best_cost_index = 0;
        double best_cost = N.get((int)best_cost_index).cost;
        for (int n_ind = 1; n_ind < N.size(); ++n_ind) {
            if (!(N.get((int)n_ind).cost < best_cost)) continue;
            best_cost_index = n_ind;
            best_cost = N.get((int)best_cost_index).cost;
        }
        return N.get(best_cost_index);
    }

    public List<Plan> PlanFromSolution(Candidate A) {
        ArrayList<Plan> plan_list = new ArrayList<Plan>();
        for (int vehicle_ind = 0; vehicle_ind < A.vehicles.size(); ++vehicle_ind) {
            Vehicle v = A.vehicles.get(vehicle_ind);
            List<PD_Action> plan = A.plans.get(vehicle_ind);
            Topology.City current_city = v.getCurrentCity();
            Plan v_plan = new Plan(current_city, new Action[0]);
            for (PD_Action act : plan) {
                Topology.City next_city = act.is_pickup ? act.task.pickupCity : act.task.deliveryCity;
                for (Topology.City move_city : current_city.pathTo(next_city)) {
                    v_plan.appendMove(move_city);
                }
                if (act.is_pickup) {
                    v_plan.appendPickup(act.task);
                } else {
                    v_plan.appendDelivery(act.task);
                }
                current_city = next_city;
            }
            plan_list.add(v_plan);
        }
        return plan_list;
    }

    private double calculateExpectedFutureValue(Topology.City currentCity, TaskDistribution distribution) {
        double efv = 0.0;
        for (Topology.City destination : this.topology.cities()) {
            if (destination.equals((Object)currentCity)) continue;
            double probability = distribution.probability(currentCity, destination);
            int reward = distribution.reward(currentCity, destination);
            efv += probability * (double)reward;
        }
        return efv;
    }
}

