/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class Test2a_v4
implements AuctionBehavior {
    private Topology topology;
    private Agent agent;
    private List<Vehicle> vehicles;
    private Random random;
    private double opponentCostEstimate;
    private double marginFactor;
    private List<Long> opponentBidsHistory;
    private static final int BID_HISTORY_SIZE = 10;
    private int consecutiveWins;
    private Map<Vehicle, List<Task>> vehicleTasks;
    private Map<Vehicle, List<Task>> pendingTasks;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.agent = agent;
        this.vehicles = agent.vehicles();
        this.random = new Random(agent.id());
        this.opponentCostEstimate = 0.0;
        this.marginFactor = 3.0;
        this.opponentBidsHistory = new ArrayList<Long>();
        this.vehicleTasks = new HashMap<Vehicle, List<Task>>();
        this.pendingTasks = new HashMap<Vehicle, List<Task>>();
        this.consecutiveWins = 0;
        for (Vehicle vehicle : this.vehicles) {
            this.vehicleTasks.put(vehicle, new ArrayList());
            this.pendingTasks.put(vehicle, new ArrayList());
        }
    }

    public Long askPrice(Task task) {
        if (this.vehicles.get(0).capacity() < task.weight) {
            return null;
        }
        double bestCost = Double.MAX_VALUE;
        for (Vehicle vehicle : this.vehicles) {
            double vehicleCost = this.calculateMarginalCost(vehicle, task);
            bestCost = Math.min(bestCost, vehicleCost);
        }
        double predictedOpponentBid = this.predictOpponentBid(task);
        double adjustedBid = this.computeDynamicBid(task.reward, bestCost, predictedOpponentBid);
        return Math.round(adjustedBid);
    }

    private double calculateMarginalCost(Vehicle vehicle, Task task) {
        ArrayList<Task> simulatedTasks = new ArrayList<Task>((Collection)this.vehicleTasks.get(vehicle));
        simulatedTasks.add(task);
        double currentCost = this.calculateRouteCost(vehicle, this.vehicleTasks.get(vehicle));
        double newCost = this.calculateRouteCost(vehicle, simulatedTasks);
        return newCost - currentCost;
    }

    private double calculateRouteCost(Vehicle vehicle, List<Task> tasks) {
        Topology.City currentCity = vehicle.getCurrentCity();
        double cost = 0.0;
        for (Task task : tasks) {
            cost += currentCity.distanceTo(task.pickupCity) * (double)vehicle.costPerKm();
            cost += task.pickupCity.distanceTo(task.deliveryCity) * (double)vehicle.costPerKm();
            currentCity = task.deliveryCity;
        }
        return cost;
    }

    private double predictOpponentBid(Task task) {
        if (this.opponentBidsHistory.isEmpty()) {
            return this.opponentCostEstimate;
        }
        double weight = 1.0;
        double weightedSum = 0.0;
        double weightSum = 0.0;
        for (int i = this.opponentBidsHistory.size() - 1; i >= 0; --i) {
            weightedSum += (double)this.opponentBidsHistory.get(i).longValue() * weight;
            weightSum += weight;
            weight *= 0.9;
        }
        double taskValue = (double)task.reward / (task.pickupCity.distanceTo(task.deliveryCity) + 1.0);
        return weightedSum / weightSum + taskValue * 0.1;
    }

    private double computeDynamicBid(double taskReward, double marginalCost, double opponentPrediction) {
        double profitMargin = 0.15 + 0.05 * Math.log(1.0 + taskReward / marginalCost);
        double dynamicBid = marginalCost * (1.0 + profitMargin);
        if (opponentPrediction > 0.0) {
            dynamicBid = Math.min(dynamicBid, opponentPrediction - this.random.nextDouble() * 50.0);
        }
        return Math.max(marginalCost, dynamicBid);
    }

    public void auctionResult(Task previous, int winner, Long[] offers) {
        if (offers.length > 1) {
            if (winner == this.agent.id()) {
                Vehicle assignedVehicle = this.selectVehicleForTask(previous);
                this.pendingTasks.get(assignedVehicle).add(previous);
                ++this.consecutiveWins;
                this.marginFactor += 0.1;
            } else {
                this.consecutiveWins = 0;
                this.marginFactor = Math.max(2.5, this.marginFactor - 0.05);
            }
            long opponentBid = offers[1 - this.agent.id()];
            this.opponentBidsHistory.add(opponentBid);
            if (this.opponentBidsHistory.size() > 10) {
                this.opponentBidsHistory.remove(0);
            }
        }
    }

    private Vehicle selectVehicleForTask(Task task) {
        Vehicle bestVehicle = null;
        double bestCost = Double.MAX_VALUE;
        for (Vehicle vehicle : this.vehicles) {
            double vehicleCost = this.calculateMarginalCost(vehicle, task);
            if (!(vehicleCost < bestCost)) continue;
            bestCost = vehicleCost;
            bestVehicle = vehicle;
        }
        return bestVehicle;
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (Vehicle vehicle : vehicles) {
            Plan vehiclePlan = this.createOptimizedPlan(vehicle, this.pendingTasks.get(vehicle));
            plans.add(vehiclePlan);
            this.pendingTasks.get(vehicle).clear();
        }
        return plans;
    }

    private Plan createOptimizedPlan(Vehicle vehicle, List<Task> tasks) {
        Plan plan = new Plan(vehicle.getCurrentCity(), new Action[0]);
        Topology.City currentCity = vehicle.getCurrentCity();
        ArrayList<Task> sortedTasks = new ArrayList<Task>(tasks);
        sortedTasks.sort(Comparator.comparingDouble(task -> vehicle.getCurrentCity().distanceTo(task.pickupCity) + task.pickupCity.distanceTo(task.deliveryCity)));
        for (Task task2 : sortedTasks) {
            for (Topology.City city : currentCity.pathTo(task2.pickupCity)) {
                plan.appendMove(city);
            }
            plan.appendPickup(task2);
            for (Topology.City city : task2.pickupCity.pathTo(task2.deliveryCity)) {
                plan.appendMove(city);
            }
            plan.appendDelivery(task2);
            currentCity = task2.deliveryCity;
        }
        return plan;
    }
}

