/*
 * Decompiled with CFR 0.152.
 */
package PastaLoverAgent;

import java.util.ArrayList;
import java.util.Comparator;
import logist.task.Task;
import logist.topology.Topology;

public class MyTask
implements Comparator,
Comparable {
    private Topology.City deliveryCity;
    private int id;
    private Topology.City pickupCity;
    private long reward;
    private int weight;
    private double proba;

    public MyTask(int id, Topology.City pickupCity, Topology.City deliveryCity, long reward, int weight, double proba) {
        this.deliveryCity = deliveryCity;
        this.id = id;
        this.pickupCity = pickupCity;
        this.reward = reward;
        this.weight = weight;
        this.proba = proba;
    }

    public boolean notIn(ArrayList tasks) {
        for (Task t : tasks) {
            if (!t.pickupCity.equals((Object)this.pickupCity) || !t.deliveryCity.equals((Object)this.deliveryCity)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(MyTask n) {
        return this.id == n.getId();
    }

    public int compareTo(MyTask o) {
        return this.compare(this, o);
    }

    public int compare(MyTask n1, MyTask n2) {
        double c = n1.getProba() - n2.getProba();
        if (c < 0.0) {
            return 1;
        }
        return c <= 0.0 ? 0 : -1;
    }

    public Task generateTask(int id) {
        return new Task(id, this.pickupCity, this.deliveryCity, this.reward, this.weight);
    }

    public Topology.City getDeliveryCity() {
        return this.deliveryCity;
    }

    public void setDeliveryCity(Topology.City deliveryCity) {
        this.deliveryCity = deliveryCity;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Topology.City getPickupCity() {
        return this.pickupCity;
    }

    public void setPickupCity(Topology.City pickupCity) {
        this.pickupCity = pickupCity;
    }

    public long getReward() {
        return this.reward;
    }

    public void setReward(long reward) {
        this.reward = reward;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public double getProba() {
        return this.proba;
    }

    public void setProba(double proba) {
        this.proba = proba;
    }

    public int compare(Object obj, Object obj1) {
        return this.compare((MyTask)obj, (MyTask)obj1);
    }

    public int compareTo(Object obj) {
        return this.compareTo((MyTask)obj);
    }
}

