/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloIntToNumFunction;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.yz;

class hn
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;
    protected IloIntToNumFunction _func;
    protected double _min;
    protected double _max;

    hn(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2, IloIntToNumFunction iloIntToNumFunction, double d2, double d3) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
        this._func = iloIntToNumFunction;
        this._min = d2;
        this._max = d3;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        kh kh2 = (kh)this._var1.getExtracted(ilcSolver);
        kh kh3 = (kh)this._var2.getExtracted(ilcSolver);
        return new mj(kh2, kh3, this._func, this._min, this._max);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rangedSubsetEq(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(", ");
        stringBuffer.append(this._func);
        stringBuffer.append(", ");
        stringBuffer.append(this._min);
        stringBuffer.append(", ");
        stringBuffer.append(this._max);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSetVar iloIntSetVar = (IloIntSetVar)iloCopyManager.getCopy(this._var1);
        IloIntSetVar iloIntSetVar2 = (IloIntSetVar)iloCopyManager.getCopy(this._var2);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.rangedSubsetEq(iloIntSetVar, iloIntSetVar2, this._func, this._min, this._max);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
    }

    static final class mj
    extends IlcPPropagator {
        final kh nu;
        final kh ou;
        final IloIntToNumFunction pu;
        final double qu;
        final double ru;

        public mj(kh kh2, kh kh3, IloIntToNumFunction iloIntToNumFunction, double d2, double d3) {
            this.nu = kh2;
            this.ou = kh3;
            this.pu = iloIntToNumFunction;
            this.qu = d2;
            this.ru = d3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.nu.whenDomain(ilcDemon);
            this.ou.whenDomain(ilcDemon);
        }

        public void post() {
            this.nu.getSolver().add(new yz.pm(this.nu.getCardinality(), this.ou.getCardinality()));
            this.nu.whenDomain(new cf());
            this.ou.whenDomain(new kbb());
        }

        public void propagate() {
            IlcIterator ilcIterator = this.nu.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                double d2 = this.pu.getValue(n2);
                if (!this.ou.isDomainPossible(n2)) {
                    this.nu.removeDomainPossible(n2);
                    continue;
                }
                if (d2 < this.qu || d2 > this.ru) {
                    this.nu.removeDomainPossible(n2);
                    continue;
                }
                if (!this.nu.isDomainRequired(n2)) continue;
                this.ou.addDomainRequired(n2);
            }
        }

        public boolean isViolated() {
            IlcIterator ilcIterator = this.nu.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                double d2 = this.pu.getValue(n2);
                if (!(d2 < this.qu) && !(d2 > this.ru) && this.ou.isDomainPossible(n2)) continue;
                return true;
            }
            return false;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rangedSubsetEq(");
            stringBuffer.append(this.nu);
            stringBuffer.append(", ");
            stringBuffer.append(this.ou);
            stringBuffer.append(", ");
            stringBuffer.append(this.pu);
            stringBuffer.append(", ");
            stringBuffer.append(this.qu);
            stringBuffer.append(", ");
            stringBuffer.append(this.ru);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        final class kbb
        extends IlcDemon {
            kbb() {
            }

            public void propagate() {
                IlcIterator ilcIterator = mj.this.ou.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    mj.this.nu.removeDomainPossible(ilcIterator.nextValue());
                }
            }
        }

        final class cf
        extends IlcDemon {
            cf() {
            }

            public void propagate() {
                IlcIterator ilcIterator = mj.this.nu.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    int n2 = ilcIterator.nextValue();
                    double d2 = mj.this.pu.getValue(n2);
                    if (d2 < mj.this.qu || d2 > mj.this.ru) {
                        mj.this.nu.getSolver().fail();
                        continue;
                    }
                    mj.this.ou.addDomainRequired(n2);
                }
            }
        }
    }
}

