/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.List;
import java.util.Random;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import template.Solution;

public class SLS {
    private List<Vehicle> vehicles;
    private Random rn;
    private long globalTimeout;
    private double p;
    private Solution currentSolution;
    private Solution bestSolution;

    public SLS(List<Vehicle> vehicles, long timeoutPlan, double p, Random rn) {
        this.vehicles = vehicles;
        this.globalTimeout = timeoutPlan;
        this.p = p;
        this.rn = rn;
        this.currentSolution = new Solution(vehicles);
        this.bestSolution = this.currentSolution.clone();
        System.out.println("[SLS] Initialized with " + vehicles.size() + " vehicles. Timeout: " + timeoutPlan + " p=" + p);
    }

    public double marginalCost(Task t, double timeout) {
        System.out.println("[SLS.marginalCost] Computing marginal cost for task " + t.id);
        Solution backup = this.currentSolution.clone();
        double oldCost = backup.totalCost(this.vehicles);
        Solution candidate = backup.clone();
        candidate.addTask(t, this.rn);
        Solution improved = this.findBestSolution(candidate, timeout);
        if (improved == null) {
            System.out.println("[SLS.marginalCost] No improved solution found for task " + t.id);
            return Double.MAX_VALUE;
        }
        double newCost = improved.totalCost(this.vehicles);
        double marginal = newCost - oldCost;
        System.out.println("[SLS.marginalCost] Marginal: " + marginal + " (oldCost=" + oldCost + ", newCost=" + newCost + ")");
        return Math.max(marginal, 0.0);
    }

    public void confirmTask(Task t) {
        System.out.println("[SLS.confirmTask] Confirming task " + t.id);
        Solution newSol = this.currentSolution.clone();
        newSol.addTask(t, this.rn);
        newSol = this.findBestSolution(newSol, this.globalTimeout / 10L);
        if (newSol != null && newSol.isValid()) {
            this.currentSolution = newSol;
            if (this.currentSolution.totalCost(this.vehicles) < this.bestSolution.totalCost(this.vehicles)) {
                this.bestSolution = this.currentSolution.clone();
            }
            System.out.println("[SLS.confirmTask] Task " + t.id + " confirmed!");
        } else {
            System.out.println("[SLS.confirmTask] WARNING: Could not confirm task " + t.id + " properly or invalid solution.");
        }
    }

    public List<Plan> computeFinalPlan(double timeout) {
        System.out.println("[SLS.computeFinalPlan] Computing final plan");
        Solution finalSol = this.findBestSolution(this.currentSolution, timeout);
        if (finalSol == null || !finalSol.isValid()) {
            System.out.println("[SLS.computeFinalPlan] Final solution invalid or null.");
            return null;
        }
        List<Plan> plans = finalSol.getPlans(this.vehicles);
        System.out.println("[SLS.computeFinalPlan] Final solution cost: " + finalSol.totalCost(this.vehicles));
        return plans;
    }

    public double getCurrentCost(List<Vehicle> vs) {
        return this.currentSolution.totalCost(vs);
    }

    private Solution findBestSolution(Solution initSol, double timeout) {
        if (initSol == null) {
            return null;
        }
        double start = System.currentTimeMillis();
        Solution A = initSol.clone();
        Solution best = A.clone();
        double bestCost = best.totalCost(this.vehicles);
        int iterations = 0;
        while ((double)System.currentTimeMillis() - start < timeout) {
            ++iterations;
            List<Solution> neighbors = A.chooseNeighbors(this.rn);
            neighbors.removeIf(n -> !n.isValid());
            if (neighbors.isEmpty()) break;
            Solution next = this.localChoice(neighbors, A);
            double cost = next.totalCost(this.vehicles);
            if (cost < bestCost) {
                best = next.clone();
                bestCost = cost;
            }
            A = next;
        }
        System.out.println("[SLS.findBestSolution] Done in " + iterations + " iterations. Best cost: " + bestCost);
        if (!best.isValid()) {
            System.out.println("[SLS.findBestSolution] Best solution not valid.");
            return null;
        }
        return best;
    }

    private Solution localChoice(List<Solution> N, Solution A) {
        if ((double)this.rn.nextFloat() < this.p) {
            return A;
        }
        double bestCost = Double.MAX_VALUE;
        Solution bestSol = A;
        for (Solution s : N) {
            double cost = s.totalCost(this.vehicles);
            if (!(cost < bestCost)) continue;
            bestCost = cost;
            bestSol = s;
        }
        return bestSol;
    }
}

