/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import cern.jet.random.Uniform;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import uchicago.src.sim.util.Remover;

public class ConservationCollection {
    private Remover remover = null;
    private int limit;
    private Vector vector;

    public ConservationCollection(int n) {
        this.limit = n;
        this.vector = new Vector(n + 25);
    }

    private void conserve(int n) {
        if (this.remover == null) {
            for (int i = 0; i < n; ++i) {
                int n2 = Uniform.staticNextIntFromTo((int)0, (int)(this.vector.size() - 1));
                this.vector.remove(n2);
            }
        } else {
            this.vector = this.remover.remove(this.vector, n);
        }
    }

    public boolean add(Object object) {
        this.vector.add(object);
        if (this.vector.size() > this.limit) {
            this.conserve(1);
        }
        return true;
    }

    public void add(int n, Object object) {
        this.vector.add(n, object);
        if (this.vector.size() > this.limit) {
            this.conserve(1);
        }
    }

    public boolean addAll(Collection collection) {
        this.vector.addAll(collection);
        if (this.vector.size() > this.limit) {
            this.conserve(this.vector.size() - this.limit);
        }
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        this.vector.addAll(n, collection);
        if (this.vector.size() > this.limit) {
            this.conserve(this.vector.size() - this.limit);
        }
        return true;
    }

    public void clear() {
        this.vector.clear();
    }

    public boolean contains(Object object) {
        return this.vector.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.vector.contains(collection);
    }

    public boolean equals(Object object) {
        if (object instanceof ConservationCollection) {
            ConservationCollection conservationCollection = (ConservationCollection)object;
            return this.vector == conservationCollection.vector;
        }
        return false;
    }

    public Object get(int n) {
        return this.vector.get(n);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public int indexOf(Object object) {
        return this.vector.indexOf(object);
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(Object object) {
        return this.vector.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        ListIterator listIterator = this.vector.listIterator(n);
        return new ConservationIterator(listIterator, this);
    }

    public Object remove(int n) {
        return this.vector.remove(n);
    }

    public boolean remove(Object object) {
        return this.vector.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.vector.remove(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.vector.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.vector.set(n, object);
    }

    public int size() {
        return this.vector.size();
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException("subList not supported by ConservationCollection");
    }

    public Object[] toArray() {
        return this.vector.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.vector.toArray(objectArray);
    }

    class ConservationIterator
    implements ListIterator {
        ListIterator i;
        ConservationCollection collection;

        public ConservationIterator(ListIterator listIterator, ConservationCollection conservationCollection2) {
            this.i = listIterator;
            this.collection = conservationCollection2;
        }

        public void add(Object object) {
            if (this.collection.vector.size() >= ConservationCollection.this.limit) {
                throw new IllegalArgumentException("ConservationCollection is at its limit");
            }
            this.i.add(object);
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public Object next() {
            return this.i.next();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public Object previous() {
            return this.i.previous();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void remove() {
            this.i.remove();
        }

        public void set(Object object) {
            this.i.set(object);
        }
    }
}

