/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.DrawableItem;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.NonGridDrawable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.space.VectorSpace;

public class VectorDisplay
implements Displayable,
Probeable {
    protected boolean view = true;
    private int height;
    private int width;
    protected VectorSpace space;

    public VectorDisplay(VectorSpace vectorSpace, int n, int n2) {
        this.space = vectorSpace;
        this.width = n;
        this.height = n2;
    }

    public VectorDisplay(List list, int n, int n2) {
        this(new VectorSpace(list), n, n2);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawDisplay(SimGraphics simGraphics) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2 = this.space.getMembers();
        synchronized (arrayList3) {
            arrayList = (ArrayList)arrayList2.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NonGridDrawable nonGridDrawable = (NonGridDrawable)arrayList.get(i);
            simGraphics.setDrawingParameters(nonGridDrawable.getWidth(), nonGridDrawable.getHeight(), 0);
            simGraphics.setDrawingCoordinates((int)nonGridDrawable.getX(), (int)nonGridDrawable.getY(), 0.0f);
            nonGridDrawable.draw(simGraphics);
        }
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("", -1, this));
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        this.view = viewEvent.showView();
    }

    public ArrayList getObjectsAt(int n, int n2) {
        ArrayList arrayList = this.space.getMembers();
        Point point = new Point(n, n2);
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            DrawableItem drawableItem;
            Object e = arrayList.get(i);
            if (!(e instanceof DrawableItem) || !(drawableItem = (DrawableItem)e).contains(point)) continue;
            arrayList2.add(e);
        }
        return arrayList2;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        moveable.setX(n);
        moveable.setY(n2);
    }

    public void reSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }
}

