/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.security;

import epfl.lia.logist.security.SecurityRuleOpEnum;
import epfl.lia.logist.security.SecurityRuleRightsEnum;

public class SecurityRule {
    private SecurityRuleOpEnum meOperator = SecurityRuleOpEnum.SROP_ANY;
    private String msRefValue = null;
    private SecurityRuleRightsEnum meRights = SecurityRuleRightsEnum.SRRG_DENY;

    public SecurityRule(SecurityRuleOpEnum op, String ref, SecurityRuleRightsEnum rights) {
        this.meOperator = op;
        this.msRefValue = ref;
        this.meRights = rights;
    }

    public boolean eval() throws SecurityException {
        ThreadGroup l_thrGroup = Thread.currentThread().getThreadGroup();
        if (l_thrGroup == null) {
            throw new SecurityException();
        }
        String l_thrGroupID = l_thrGroup.getName();
        switch (this.meOperator) {
            case SROP_EQ: {
                if (!l_thrGroupID.equals(this.msRefValue)) break;
                if (this.meRights == SecurityRuleRightsEnum.SRRG_GRANT) {
                    return true;
                }
                throw new SecurityException("Unauthorized access");
            }
            case SROP_NEQ: {
                if (l_thrGroupID.equals(this.msRefValue) || this.meRights != SecurityRuleRightsEnum.SRRG_DENY) break;
                throw new SecurityException("Unauthorized access");
            }
            case SROP_ANY: {
                if (this.meRights != SecurityRuleRightsEnum.SRRG_DENY) break;
                throw new SecurityException("Unauthorized access");
            }
        }
        return false;
    }
}

