/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging.format;

import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogEntry;
import epfl.lia.logist.logging.LogOutputFormat;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class RawLogOutputFormat
implements LogOutputFormat {
    private PrintStream moFileStream = null;
    private LogDescriptor moDescriptor = null;

    public RawLogOutputFormat(LogDescriptor d) throws Exception {
        this.moDescriptor = d;
        this.moFileStream = new PrintStream(d.File);
    }

    public void outputEntry(LogEntry e) {
        String lsDate = String.format("%1$tH:%1$tM:%1$tS", new Date());
        this.moFileStream.printf("[%s] %-8s: %s\n", new Object[]{lsDate, e.getSeverity(), e.getText()});
    }

    public void init() {
        this.outputFileHeader();
    }

    public void close() {
        this.outputFileFooter();
    }

    private void outputFileHeader() {
        String lsJVMVendor = "java-vendor     : " + System.getProperty("java.vendor");
        String lsJVMVendorURL = "java-vendor-url : " + System.getProperty("java.vendor.url");
        String lsJVMVersion = "java-version    : " + System.getProperty("java.version");
        String lsOsArch = "os-arch         : " + System.getProperty("os.arch");
        String lsOsName = "os-name         : " + System.getProperty("os.name");
        String lsUsername = "user-name       : " + System.getProperty("user.name");
        String lsCacheSize = "cache-size      : " + this.moDescriptor.CacheSize;
        String lsMaxEntries = "max-entries     : " + this.moDescriptor.MaxEntries;
        String lsDebugLevel = "debug-level     : " + this.moDescriptor.DebugLevel;
        this.moFileStream.println("Logist Platform RAW Log Output:");
        this.moFileStream.println("===============================\n\n");
        this.moFileStream.println("Starting date : " + String.format("%1$ta %1$tb %1$td %1$tT %1$tZ %1$tY", new GregorianCalendar()));
        this.moFileStream.println("Starting time : " + String.format("%1$tH:%1$tM:%1$tS", new GregorianCalendar()));
        this.moFileStream.println("\nGeneral environnement info:\n");
        this.moFileStream.println("\t" + lsJVMVendor);
        this.moFileStream.println("\t" + lsJVMVendorURL);
        this.moFileStream.println("\t" + lsJVMVersion);
        this.moFileStream.println("\t" + lsOsArch);
        this.moFileStream.println("\t" + lsOsName);
        this.moFileStream.println("\t" + lsUsername);
        this.moFileStream.println("\t" + lsCacheSize);
        this.moFileStream.println("\t" + lsMaxEntries);
        this.moFileStream.println("\t" + lsDebugLevel + "\n\n");
        this.moFileStream.println("Log file entries:\n");
    }

    private void outputFileFooter() {
        this.moFileStream.println("\n\n--| End of log |------------------------------------------------------");
    }
}

