/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.topology.Topology;
import template.Candidate;
import template.PD_Action;
import template.Pair;

public class CentralizedPlan {
    public static Pair<List<Plan>, Candidate> plan(List<Vehicle> vehicles, ArrayList<Task> tasks, Random random, long timeout_plan, double p) {
        long time_start = System.currentTimeMillis();
        ArrayList<Task> task_list = new ArrayList<Task>(tasks);
        Candidate A = Candidate.SelectInitialSolution(random, vehicles, task_list);
        if (tasks.size() == 0) {
            return new Pair<List<Plan>, Candidate>(CentralizedPlan.PlanFromSolution(A), A);
        }
        boolean timeout_reached = false;
        while (!timeout_reached) {
            Candidate A_old = A;
            List<Candidate> N = A_old.ChooseNeighbours(random);
            A = CentralizedPlan.LocalChoice(N, A_old, random, p);
            if (System.currentTimeMillis() - time_start <= timeout_plan) continue;
            timeout_reached = true;
        }
        List<Plan> plan = CentralizedPlan.PlanFromSolution(A);
        long time_end = System.currentTimeMillis();
        long duration = time_end - time_start;
        double cost_plan = A.cost;
        return new Pair<List<Plan>, Candidate>(plan, A);
    }

    public static Candidate LocalChoice(List<Candidate> N, Candidate A, Random random, double p) {
        if ((double)random.nextFloat() < p) {
            return A;
        }
        int best_cost_index = 0;
        double best_cost = N.get((int)best_cost_index).cost;
        for (int n_ind = 1; n_ind < N.size(); ++n_ind) {
            if (!(N.get((int)n_ind).cost < best_cost)) continue;
            best_cost_index = n_ind;
            best_cost = N.get((int)best_cost_index).cost;
        }
        return N.get(best_cost_index);
    }

    public static List<Plan> PlanFromSolution(Candidate A) {
        return CentralizedPlan.PlanFromSolution(A, null, null);
    }

    public static List<Plan> PlanFromSolution(Candidate A, ArrayList<Task> mapping_from, ArrayList<Task> mapping_to) {
        boolean mapping = mapping_from != null;
        HashMap<Integer, Task> mappingHashMap = new HashMap<Integer, Task>();
        if (mapping) {
            for (Task task : mapping_from) {
                for (Task task1 : mapping_to) {
                    if (task.reward != task1.reward || task.id != task1.id || !task.pickupCity.toString().equals(task.pickupCity.toString()) || !task.deliveryCity.toString().equals(task1.deliveryCity.toString()) || task.weight != task1.weight) continue;
                    mappingHashMap.put(task.id, task1);
                }
            }
            if (mappingHashMap.keySet().size() != mapping_to.size()) {
                return null;
            }
        }
        ArrayList<Plan> plan_list = new ArrayList<Plan>();
        for (int vehicle_ind = 0; vehicle_ind < A.vehicles.size(); ++vehicle_ind) {
            Vehicle v = A.vehicles.get(vehicle_ind);
            List<PD_Action> plan = A.plans.get(vehicle_ind);
            Topology.City current_city = v.getCurrentCity();
            Plan v_plan = new Plan(current_city, new Action[0]);
            for (PD_Action act : plan) {
                Task task = act.task;
                if (mapping) {
                    if (!mappingHashMap.containsKey(task.id)) {
                        return null;
                    }
                    task = (Task)mappingHashMap.get(task.id);
                }
                Topology.City next_city = act.is_pickup ? task.pickupCity : task.deliveryCity;
                for (Topology.City move_city : current_city.pathTo(next_city)) {
                    v_plan.appendMove(move_city);
                }
                if (act.is_pickup) {
                    v_plan.appendPickup(task);
                } else {
                    v_plan.appendDelivery(task);
                }
                current_city = next_city;
            }
            plan_list.add(v_plan);
        }
        return plan_list;
    }
}

