/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging.format;

import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogEntry;
import epfl.lia.logist.logging.LogOutputFormat;
import epfl.lia.logist.logging.LogSeverityEnum;
import java.io.PrintStream;
import java.util.Date;

public class StreamLogOutputFormat
implements LogOutputFormat {
    private PrintStream moOutStream = null;
    private PrintStream moErrStream = null;

    public StreamLogOutputFormat(LogDescriptor d) throws Exception {
        if (d.File.toLowerCase().equals("stdout")) {
            this.moOutStream = System.out;
            this.moErrStream = System.err;
        } else {
            this.moOutStream = System.out;
            this.moErrStream = System.err;
        }
    }

    public void outputEntry(LogEntry e) {
        String lsDate = String.format("%1$tH:%1$tM:%1$tS", new Date());
        if (e.getSeverity() == LogSeverityEnum.LSV_WARNING || e.getSeverity() == LogSeverityEnum.LSV_ERROR || e.getSeverity() == LogSeverityEnum.LSV_FATAL) {
            this.moErrStream.printf("[%s] %-8s: %s\n", new Object[]{lsDate, e.getSeverity(), e.getText()});
        } else {
            this.moOutStream.printf("[%s] %-8s: %s\n", new Object[]{lsDate, e.getSeverity(), e.getText()});
        }
    }

    public void init() {
        this.outputFileHeader();
    }

    public void close() {
        this.outputFileFooter();
    }

    private void outputFileHeader() {
    }

    private void outputFileFooter() {
    }
}

