/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging;

import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogFile;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.tools.LogistGlobals;
import java.io.File;
import java.util.HashMap;

public class LogManager
implements IService {
    public static String DEFAULT = "main";
    public static String ERR = "stdout";
    public static String OUT = "stdout";
    protected HashMap<String, LogFile> mMapOfLogs = null;
    private static LogManager msSingleton = null;
    private boolean mbIsInitialized = false;
    private LogistGlobals mGlobals = null;

    public LogManager() {
        if (msSingleton == null) {
            msSingleton = this;
        }
        this.mMapOfLogs = new HashMap();
    }

    public void createLog(LogDescriptor lfd) throws Exception {
        LogFile lf = null;
        lf = this.mGlobals == null ? new LogFile() : new LogFile(this.mGlobals.ClassPath);
        if (this.mMapOfLogs.containsKey(lfd.ID)) {
            return;
        }
        if (lf.create(lfd)) {
            this.mMapOfLogs.put(lfd.ID, lf);
        }
    }

    public LogFile deleteLog(String ID) {
        LogFile lLog = this.mMapOfLogs.remove(ID);
        if (lLog == null) {
            return null;
        }
        lLog.destroy();
        return lLog;
    }

    public static synchronized LogManager getInstance() {
        return msSingleton;
    }

    public void init() throws Exception {
        if (this.mbIsInitialized) {
            return;
        }
        LogDescriptor lOutLogDsc = new LogDescriptor();
        lOutLogDsc.ID = "stdout";
        lOutLogDsc.File = "stdout";
        lOutLogDsc.Format = "stream";
        lOutLogDsc.FormatClass = null;
        lOutLogDsc.DebugLevel = "debug";
        lOutLogDsc.MaxEntries = 0;
        lOutLogDsc.CacheSize = 1;
        lOutLogDsc.ToStdout = false;
        this.createLog(lOutLogDsc);
        LogDescriptor lMainLogDsc = new LogDescriptor();
        lMainLogDsc.ID = "main";
        lMainLogDsc.File = "logist";
        lMainLogDsc.Format = "raw";
        lMainLogDsc.FormatClass = null;
        lMainLogDsc.DebugLevel = "debug";
        lMainLogDsc.MaxEntries = 0;
        lMainLogDsc.CacheSize = 5;
        lMainLogDsc.ToStdout = true;
        this.createLog(lMainLogDsc);
    }

    public void shutdown() {
        String[] lStringArray = new String[this.mMapOfLogs.keySet().size()];
        this.mMapOfLogs.keySet().toArray(lStringArray);
        int i = 0;
        while (i < lStringArray.length) {
            this.deleteLog(lStringArray[i]);
            ++i;
        }
    }

    public void setup(Configuration cfg, LogistGlobals lg) throws Exception {
        this.mGlobals = lg;
        if (cfg.Logs.Logs == null || cfg.Logs.Logs.isEmpty()) {
            return;
        }
        HashMap<String, LogDescriptor> logs = cfg.Logs.Logs;
        File logDir = new File(lg.LogPath);
        for (LogDescriptor ld : logs.values()) {
            if (logDir.exists()) {
                File logFile = new File(logDir, ld.File);
                ld.File = logFile.getAbsolutePath();
            }
            this.createLog(ld);
            this.log(DEFAULT, LogSeverityEnum.LSV_INFO, "Created log file named '" + ld.ID + "' !");
        }
    }

    public void reset(int round) {
        for (LogFile l : this.mMapOfLogs.values()) {
            l.flush();
        }
    }

    public void log(String ID, LogSeverityEnum s, String msg) {
        LogFile lf = this.mMapOfLogs.get(ID);
        if (lf != null) {
            lf.log(s, msg);
        } else {
            System.out.println("Log error: " + msg + "(" + this.mMapOfLogs.size() + ")");
        }
    }

    public void flush(String ID) {
        LogFile lf = this.mMapOfLogs.get(ID);
        if (lf != null) {
            lf.flush();
        }
    }

    public String toString() {
        return "Log management service";
    }

    public void debug(String message) {
        this.log(DEFAULT, LogSeverityEnum.LSV_DEBUG, message);
    }

    public void info(String message) {
        this.log(DEFAULT, LogSeverityEnum.LSV_INFO, message);
    }

    public void warning(String message) {
        this.log(DEFAULT, LogSeverityEnum.LSV_WARNING, message);
    }

    public void error(String message) {
        this.log(DEFAULT, LogSeverityEnum.LSV_ERROR, message);
    }
}

