/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core.topology;

import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.core.listeners.ITopologyListener;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.CityDescriptor;
import epfl.lia.logist.core.topology.Route;
import epfl.lia.logist.core.topology.RouteDescriptor;
import epfl.lia.logist.core.topology.TopologyDescriptor;
import epfl.lia.logist.exception.TopologyCreationException;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.tools.LogistGlobals;
import epfl.lia.logist.tools.dijkstra.DijkstraAlgorithm;
import epfl.lia.logist.tools.dijkstra.ShortestPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import uchicago.src.sim.network.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topology
implements IService {
    private HashMap<String, City> mMapOfCities = null;
    private ArrayList<Route> mListOfRoutes = null;
    private static Topology msSingleton = null;
    private ArrayList<ITopologyListener> mListeners = null;
    private LogManager mLogMgr = null;
    private ShortestPath mShortestPath = null;
    private LogistGlobals mGlobals = null;

    public Topology() {
        if (msSingleton == null) {
            msSingleton = this;
        }
        this.mMapOfCities = new HashMap();
        this.mListOfRoutes = new ArrayList();
        this.mListeners = new ArrayList();
        this.mLogMgr = LogManager.getInstance();
    }

    public boolean exists(String cityName) {
        if (cityName == null) {
            return false;
        }
        return this.mMapOfCities.get(cityName) != null;
    }

    public boolean neighbors(String city1Name, String city2Name) {
        City c1 = this.mMapOfCities.get(city1Name);
        City c2 = this.mMapOfCities.get(city2Name);
        return this.neighbors(c1, c2);
    }

    public boolean neighbors(City city1, City city2) {
        if (city1 == null || city2 == null) {
            return false;
        }
        return city1.hasEdgeToOrFrom((Node)city2);
    }

    public void create(TopologyDescriptor td) throws TopologyCreationException {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating the list of cities from descriptors...");
        for (CityDescriptor cd : td.Cities) {
            this.createCityFromDescriptor(cd);
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating the list of routes from descriptors.");
        for (RouteDescriptor rd : td.Routes) {
            this.createRouteFromDescriptor(rd);
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Computing the shortest path for all possible pairs of cities.");
        this.mShortestPath = DijkstraAlgorithm.computeShortestPath(this);
    }

    public City moveOnShortestPath(City from, City to) {
        return DijkstraAlgorithm.moveOnShortestPathTowards(this.mShortestPath, from, to);
    }

    public double shortestDistanceBetween(City from, City to) {
        return DijkstraAlgorithm.getShortestDistanceBetween(this.mShortestPath, from, to);
    }

    private void createCityFromDescriptor(CityDescriptor cd) throws TopologyCreationException {
        if (this.mMapOfCities.containsKey(cd.Name)) {
            throw new TopologyCreationException("A city named '" + cd.Name + "' already exists in topology.");
        }
        City city = new City(cd.X, cd.Y, cd.Name);
        this.mMapOfCities.put(cd.Name, city);
        for (ITopologyListener listener : this.mListeners) {
            listener.onCityAddition(city);
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Created new city " + (Object)((Object)city) + ".");
    }

    private void createRouteFromDescriptor(RouteDescriptor cd) throws TopologyCreationException {
        City cityFrom = this.mMapOfCities.get(cd.Source);
        City cityTo = this.mMapOfCities.get(cd.Destination);
        Route routeFrom = new Route((Node)cityFrom, (Node)cityTo, cd.Distance);
        Route routeTo = new Route((Node)cityTo, (Node)cityFrom, cd.Distance);
        this.mListOfRoutes.add(routeFrom);
        this.mListOfRoutes.add(routeTo);
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Creating new route between " + (Object)((Object)cityFrom) + " and " + (Object)((Object)cityTo) + ".");
    }

    public HashMap<String, City> getCities() {
        return this.mMapOfCities;
    }

    public int getDistance(City start, City end) {
        if (start.match(end)) {
            return 0;
        }
        if (start == null || end == null || !this.exists(start.getNodeLabel()) || !this.exists(end.getNodeLabel())) {
            return Integer.MAX_VALUE;
        }
        Route route = (Route)((Object)start.getEdgesTo((Node)end).iterator().next());
        if (route == null) {
            return Integer.MAX_VALUE;
        }
        return (int)route.getDistance();
    }

    public ArrayList<?> getDestinations(City city) {
        return city.getOutNodes();
    }

    public static Topology getInstance() {
        return msSingleton;
    }

    public boolean isAccessible(City from, City to) {
        HashSet setOfEdges = from.getEdgesTo((Node)to);
        return setOfEdges != null;
    }

    public City getCity(String city) {
        return this.mMapOfCities.get(city);
    }

    public City getRandomCity() {
        int lIndex = (int)((double)this.mMapOfCities.size() * Math.random());
        Node theCity = (Node)this.mMapOfCities.values().toArray()[lIndex];
        return (City)theCity;
    }

    public void addListener(ITopologyListener tcl) {
        this.mListeners.add(tcl);
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void setup(Configuration cfg, LogistGlobals lg) throws Exception {
        this.create(cfg.Topology);
        this.mGlobals = lg;
    }

    @Override
    public void reset(int round) {
    }

    public String toString() {
        return "Topology indexing service";
    }
}

