/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class AgentHistory {
    protected static final int EVT_MOVE = 0;
    protected static final int EVT_PICKUP = 1;
    protected static final int EVT_DELIVER = 2;
    private ArrayList<HistoryEvent> mEventList = new ArrayList();
    private double mTotalReward = 0.0;
    private double mTotalDistance = 0.0;
    private double mTotalCost = 0.0;
    private double mTotalGain = 0.0;
    private int mID = 0;
    private PrintStream out = null;
    private String mFilename = "default.xml";

    public AgentHistory(String name) {
        this.mFilename = String.valueOf(name) + ".xml";
    }

    public void pickup(String target) {
        this.mEventList.add(new HistoryEvent(this.mID++, 1, 0.0, 0.0));
    }

    public void move(String target, double cost, double distance) {
        this.mEventList.add(new HistoryEvent(this.mID++, 0, -cost, distance));
        this.mTotalDistance += distance;
        this.mTotalCost += cost;
        this.mTotalGain -= cost;
    }

    public void deliver(String target, double reward) {
        this.mEventList.add(new HistoryEvent(this.mID++, 2, reward, 0.0));
        this.mTotalReward += reward;
        this.mTotalGain += reward;
    }

    public void addReward(double reward) {
        this.mTotalReward += reward;
        this.mTotalGain += reward;
    }

    public void addCost(double cost) {
        this.mTotalCost += cost;
        this.mTotalGain -= cost;
    }

    public void addDistance(double distance) {
        this.mTotalDistance += distance;
    }

    public void flushRound(int round) {
        this.out.println("\t<round id=\"" + round + "\">");
        for (HistoryEvent e : this.mEventList) {
            this.out.println("\t\t" + e);
        }
        this.mEventList.clear();
        this.out.println("\t</round>");
        this.mID = 0;
    }

    public void init() throws IOException {
        FileOutputStream lOutStream = new FileOutputStream(this.mFilename);
        this.out = new PrintStream(lOutStream);
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.out.println("<history>");
    }

    public void shutdown() {
        this.out.println("\t<statistics>");
        this.out.println("\t\t<total-cost>" + this.mTotalCost + "</total-cost>");
        this.out.println("\t\t<total-reward>" + this.mTotalReward + "</total-reward>");
        this.out.println("\t\t<total-gain>" + this.mTotalGain + "</total-gain>");
        this.out.println("\t\t<total-distance>" + this.mTotalDistance + "</total-distance>");
        this.out.println("\t</statistics>");
        this.out.println("</history>");
        this.out.close();
    }

    private class HistoryEvent {
        private final int mType;
        private final double mReward;
        private final double mDistance;
        private final int mID;

        public HistoryEvent(int id, int t, double r, double d) {
            this.mID = id;
            this.mType = t;
            this.mReward = r;
            this.mDistance = d;
        }

        public String toString() {
            String result = "<action id=\"" + this.mID + "\" type=\"";
            switch (this.mType) {
                case 0: {
                    result = String.valueOf(result) + "move";
                    break;
                }
                case 1: {
                    result = String.valueOf(result) + "pickup";
                    break;
                }
                case 2: {
                    result = String.valueOf(result) + "deliver";
                }
            }
            result = String.valueOf(result) + "\" reward=\"" + this.mReward + "\" distance=\"" + this.mDistance + "\" />";
            return result;
        }
    }
}

