/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import ptolemy.plot.EditListener;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotPoint;

public class EditablePlot
extends Plot {
    private int[] _editSpecX;
    private int[] _editSpecY;
    private boolean[] _editSpecSet;
    private int _currentEditX;
    private int _currentEditY;
    private int _dataset = 0;
    private static final Color _editColor = Color.white;
    private Stack _undoStack = new Stack();
    private Stack _redoStack = new Stack();
    private Vector _editListeners = null;

    public EditablePlot() {
        this.addMouseListener(new EditMouseListener());
        this.addMouseMotionListener(new ModifyListener());
        this.addKeyListener(new UndoListener());
    }

    private synchronized void _edit(int n, int n2) {
        if (this._dataset < 0) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._undoStack.push(objectArray);
        while (!this._redoStack.empty()) {
            this._redoStack.pop();
        }
        Graphics graphics = this.getGraphics();
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        this._editPoint(n, n2);
        Vector vector = (Vector)this._points.elementAt(this._dataset);
        int n3 = 0;
        while (n3 < vector.size()) {
            int n4;
            PlotPoint plotPoint = (PlotPoint)vector.elementAt(n3);
            if (plotPoint.x >= this._xMin && plotPoint.x <= this._xMax && (n4 = (int)((plotPoint.x - this._xMin) * this._xscale) - (this._lrx - this._ulx - this._editSpecX.length)) >= 0 && n4 < this._editSpecX.length && this._editSpecSet[n4]) {
                plotPoint.y = this._yMax - (double)(this._editSpecY[n4] - this._uly) / this._yscale;
                if (plotPoint.y < this._yBottom) {
                    this._yBottom = plotPoint.y;
                }
                if (plotPoint.y > this._yTop) {
                    this._yTop = plotPoint.y;
                }
            }
            ++n3;
        }
        this.repaint();
        graphics.setXORMode(_editColor);
        int n5 = 0;
        while (n5 < this._editSpecX.length) {
            if (this._editSpecSet[n5]) {
                graphics.drawLine(this._editSpecX[n5], this._editSpecY[n5] - 1, this._editSpecX[n5], this._editSpecY[n5] + 1);
            }
            ++n5;
        }
        graphics.setPaintMode();
        this._notifyListeners(this._dataset);
    }

    private synchronized void _editPoint(int n, int n2) {
        if (this._dataset < 0) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        if (n <= this._currentEditX || n >= this._lrx) {
            return;
        }
        int n3 = this._currentEditX;
        while (n3 <= n) {
            int n4 = n3 - (this._lrx - this._editSpecX.length);
            double d = (double)(n3 - this._currentEditX) / (double)(n - this._currentEditX);
            int n5 = (int)((double)this._currentEditY + d * (double)(n2 - this._currentEditY));
            if (!this._editSpecSet[n4]) {
                this._editSpecX[n4] = n3;
                this._editSpecY[n4] = n5;
                this._editSpecSet[n4] = true;
                graphics.setXORMode(_editColor);
                graphics.drawLine(n3, n5 - 1, n3, n5 + 1);
                graphics.setPaintMode();
            }
            ++n3;
        }
        this._currentEditX = n;
        this._currentEditY = n2;
    }

    private synchronized void _editStart(int n, int n2) {
        if (this._dataset < 0) {
            return;
        }
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        int n3 = this._lrx - n + 1;
        this._editSpecX = new int[n3];
        this._editSpecY = new int[n3];
        this._editSpecSet = new boolean[n3];
        this._editSpecX[0] = n;
        this._editSpecY[0] = n2;
        this._editSpecSet[0] = true;
        this._currentEditX = n;
        this._currentEditY = n2;
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(_editColor);
        graphics.drawLine(n, n2 - 1, n, n2 + 1);
        graphics.setPaintMode();
    }

    private void _notifyListeners(int n) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((EditListener)enumeration.nextElement()).editDataModified(this, n);
        }
    }

    private void _setData(int n, double[][] dArray) {
        this._checkDatasetIndex(n);
        Vector vector = (Vector)this._points.elementAt(this._dataset);
        int n2 = vector.size();
        if (dArray[0].length < n2) {
            n2 = dArray[0].length;
        }
        int n3 = 0;
        while (n3 < n2) {
            PlotPoint plotPoint = (PlotPoint)vector.elementAt(n3);
            plotPoint.x = dArray[0][n3];
            plotPoint.y = dArray[1][n3];
            ++n3;
        }
    }

    public void addEditListener(EditListener editListener) {
        if (this._editListeners == null) {
            this._editListeners = new Vector();
        } else if (this._editListeners.contains(editListener)) {
            return;
        }
        this._editListeners.addElement(editListener);
    }

    public double[][] getData(int n) {
        this._checkDatasetIndex(n);
        Vector vector = (Vector)this._points.elementAt(this._dataset);
        int n2 = vector.size();
        double[][] dArray = new double[2][n2];
        int n3 = 0;
        while (n3 < n2) {
            PlotPoint plotPoint = (PlotPoint)vector.elementAt(n3);
            dArray[0][n3] = plotPoint.x;
            dArray[1][n3] = plotPoint.y;
            ++n3;
        }
        return dArray;
    }

    public void redo() {
        if (this._redoStack.empty()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._undoStack.push(objectArray);
        Object[] objectArray2 = (Object[])this._redoStack.pop();
        this._setData((Integer)objectArray2[0], (double[][])objectArray2[1]);
        this.repaint();
        this._notifyListeners(this._dataset);
    }

    public void removeEditListener(EditListener editListener) {
        if (this._editListeners == null) {
            return;
        }
        this._editListeners.removeElement(editListener);
    }

    public void setEditable(int n) {
        if (n >= 0) {
            this._checkDatasetIndex(n);
        }
        this._dataset = n;
    }

    public void undo() {
        if (this._undoStack.empty()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._redoStack.push(objectArray);
        Object[] objectArray2 = (Object[])this._undoStack.pop();
        this._setData((Integer)objectArray2[0], (double[][])objectArray2[1]);
        this.repaint();
        this._notifyListeners(this._dataset);
    }

    public class EditMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                EditablePlot.this._editStart(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                EditablePlot.this._edit(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class ModifyListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                EditablePlot.this._editPoint(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class UndoListener
    implements KeyListener {
        private boolean _control = false;

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 90: {
                    if (!this._control) break;
                    EditablePlot.this.undo();
                    break;
                }
                case 89: {
                    if (!this._control) break;
                    EditablePlot.this.redo();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

